/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;

@BugPattern(summary="Type-use nullability annotations should annotate the inner class, not the outer class (e.g., write `A.@Nullable B` instead of `@Nullable A.B`).", severity=BugPattern.SeverityLevel.ERROR)
public final class NullableOnContainingClass
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> NULLABLE_ANNOTATION_NAMES = ImmutableSet.of("Nullable", "NonNull", "NullableType");

    @Override
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (!(tree.getExpression() instanceof AnnotatedTypeTree)) {
            return Description.NO_MATCH;
        }
        return this.handle(((AnnotatedTypeTree)tree.getExpression()).getAnnotations(), tree, state);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.handle(tree.getModifiers().getAnnotations(), tree.getReturnType(), state);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.handle(tree.getModifiers().getAnnotations(), tree.getType(), state);
    }

    private Description handle(List<? extends AnnotationTree> annotations, Tree type, VisitorState state) {
        if (!(type instanceof MemberSelectTree)) {
            return Description.NO_MATCH;
        }
        int endOfOuterType = state.getEndPosition(((MemberSelectTree)type).getExpression());
        for (AnnotationTree annotationTree : annotations) {
            if (!NullableOnContainingClass.isTypeAnnotation(ASTHelpers.getSymbol(annotationTree)) || !NULLABLE_ANNOTATION_NAMES.contains(((Name)ASTHelpers.getType((Tree)annotationTree).tsym.getSimpleName()).toString()) || state.getEndPosition(annotationTree) >= endOfOuterType) continue;
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.builder().delete(annotationTree).replace(endOfOuterType + 1, endOfOuterType + 1, state.getSourceForNode(annotationTree) + " ").build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isTypeAnnotation(Symbol anno) {
        Target target = anno.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        return Arrays.stream(target.value()).anyMatch(t -> t.equals((Object)ElementType.TYPE_USE));
    }
}

