/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BugPattern(summary="Setting CSS outline style to none or 0 (while not otherwise providing visual focus indicators) is inaccessible for users navigating a web page without a mouse.", severity=BugPattern.SeverityLevel.WARNING)
public class OutlineNone
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    private static final com.google.errorprone.matchers.Matcher<AnnotationTree> TEMPLATE_ANNOTATION = Matchers.isType("com.google.gwt.safehtml.client.SafeHtmlTemplates.Template");
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> GWT_SET_PROPERTY = Matchers.instanceMethod().onDescendantOf("com.google.gwt.dom.client.Style").withNameMatching(Pattern.compile("setProperty(Px)?"));
    private static final Pattern OUTLINE_NONE_REGEX = Pattern.compile("outline\\s*:\\s*(none|0px)\\s*;?");
    private static final ImmutableSet<String> NONE_STRINGS = ImmutableSet.of("none", "0px");

    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!TEMPLATE_ANNOTATION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = AnnotationMatcherUtils.getArgument(tree, "value");
        String template = ASTHelpers.constValue(arg, String.class);
        if (template == null) {
            return Description.NO_MATCH;
        }
        Matcher matcher = OUTLINE_NONE_REGEX.matcher(template);
        if (!matcher.find()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> args = tree.getArguments();
        if (GWT_SET_PROPERTY.matches(tree, state) && args.size() >= 2 && "outline".equals(ASTHelpers.constValue(args.get(0), String.class)) && OutlineNone.constantNoneOrZero(args.get(1))) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean constantNoneOrZero(ExpressionTree arg) {
        Object value = ASTHelpers.constValue(arg);
        if (value instanceof String && NONE_STRINGS.contains(value)) {
            return true;
        }
        return value instanceof Number && ((Number)value).doubleValue() == 0.0;
    }
}

