/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.regex.Pattern;

@BugPattern(summary="Preconditions only accepts the %s placeholder in error message strings", severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
public class PreconditionsInvalidPlaceholder
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PRECONDITIONS_CHECK = Matchers.allOf(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Preconditions"), Matchers.staticMethod().onClass("com.google.common.base.Verify")), PreconditionsInvalidPlaceholder::secondParameterIsString);
    private static final Pattern BAD_PLACEHOLDER_REGEX = Pattern.compile("\\$s|%(?:\\d+\\$)??[dbBhHScCoxXeEfgGaAtTn]|\\{\\d+}");

    private static boolean secondParameterIsString(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(tree);
        if (!(symbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        return ((List)methodSymbol.getParameters()).size() >= 2 && ASTHelpers.isSubtype(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)1)).type, state.getSymtab().stringType, state);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String formatString;
        int expectedArgs;
        LiteralTree formatStringTree;
        if (PRECONDITIONS_CHECK.matches(tree, state) && tree.getArguments().get(1) instanceof LiteralTree && (formatStringTree = (LiteralTree)tree.getArguments().get(1)).getValue() instanceof String && (expectedArgs = PreconditionsInvalidPlaceholder.expectedArguments(formatString = (String)formatStringTree.getValue())) < tree.getArguments().size() - 2 && BAD_PLACEHOLDER_REGEX.matcher(formatString).find()) {
            return this.describe(tree, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(MethodInvocationTree tree, VisitorState state) {
        LiteralTree formatTree = (LiteralTree)tree.getArguments().get(1);
        String fixedFormatString = BAD_PLACEHOLDER_REGEX.matcher(state.getSourceForNode(formatTree)).replaceAll("%s");
        if (PreconditionsInvalidPlaceholder.expectedArguments(fixedFormatString) == tree.getArguments().size() - 2) {
            return this.describeMatch(formatTree, (Fix)SuggestedFix.replace(formatTree, fixedFormatString));
        }
        int missing = tree.getArguments().size() - 2 - PreconditionsInvalidPlaceholder.expectedArguments(fixedFormatString);
        StringBuilder builder = new StringBuilder(fixedFormatString);
        builder.deleteCharAt(builder.length() - 1);
        builder.append(" [%s");
        for (int i = 1; i < missing; ++i) {
            builder.append(", %s");
        }
        builder.append("]\"");
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(formatTree, builder.toString()));
    }

    private static int expectedArguments(String formatString) {
        int count = 0;
        int i = formatString.indexOf("%s");
        while (i != -1) {
            ++count;
            i = formatString.indexOf("%s", i + 1);
        }
        return count;
    }
}

