/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(summary="Passing a primitive array to a varargs method is usually wrong", severity=BugPattern.SeverityLevel.WARNING)
public class PrimitiveArrayPassedToVarargsMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        return PrimitiveArrayPassedToVarargsMethod.isVarargs(t, state) ? this.describeMatch(t) : Description.NO_MATCH;
    }

    private static boolean isVarargs(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (!symbol.isVarArgs()) {
            return false;
        }
        List params = symbol.getParameters();
        int varargsPosition = params.size() - 1;
        Type.ArrayType varargsParamType = (Type.ArrayType)((Symbol.VarSymbol)Iterables.getLast(params)).type;
        JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
        List arguments = methodInvocation.getArguments();
        Types types = state.getTypes();
        if (arguments.size() != params.size()) {
            return false;
        }
        Type varargsArgumentType = ((JCTree.JCExpression)arguments.get((int)varargsPosition)).type;
        if (!types.isArray(varargsArgumentType) || !types.elemtype(varargsArgumentType).isPrimitive()) {
            return false;
        }
        return !types.isSameType(varargsParamType, varargsArgumentType) && !types.isSameType(varargsParamType.getComponentType(), varargsArgumentType);
    }
}

