/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Using compareAndSet with boxed primitives is dangerous, as reference rather than value equality is used. Consider using AtomicInteger, AtomicLong, AtomicBoolean from JDK or AtomicDouble from Guava instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class PrimitiveAtomicReference
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> COMPARE_AND_SET = MethodMatchers.instanceMethod().onDescendantOf("java.util.concurrent.atomic.AtomicReference").namedAnyOf("compareAndSet", "weakCompareAndSet");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!COMPARE_AND_SET.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree firstArgument = tree.getArguments().get(0);
        if (firstArgument instanceof LiteralTree && ((LiteralTree)firstArgument).getValue() == null) {
            return Description.NO_MATCH;
        }
        Type receiverType = ASTHelpers.getType(ASTHelpers.getReceiver(tree));
        if (receiverType == null) {
            return Description.NO_MATCH;
        }
        if (receiverType.getTypeArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        Type typeArgument = receiverType.getTypeArguments().get(0);
        if (state.getTypes().unboxedType(typeArgument).getKind() == TypeKind.NONE) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

