/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Classes which are not intended to be instantiated should be made non-instantiable with a private constructor. This includes utility classes (classes with only static members), and the main class.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class PrivateConstructorForUtilityClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of("org.junit.runner.RunWith", "org.robolectric.annotation.Implements", "com.google.auto.value.AutoValue");

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS) || classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || classTree.getExtendsClause() != null || !classTree.getImplementsClause().isEmpty() || PrivateConstructorForUtilityClass.isInPrivateScope(state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol(classTree);
        for (String annotation : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Symbol)sym, annotation, state)) continue;
            return Description.NO_MATCH;
        }
        ImmutableList nonSyntheticMembers = classTree.getMembers().stream().filter(tree -> !tree.getKind().equals((Object)Tree.Kind.METHOD) || !ASTHelpers.isGeneratedConstructor((MethodTree)tree)).collect(ImmutableList.toImmutableList());
        if (nonSyntheticMembers.isEmpty() || nonSyntheticMembers.stream().anyMatch(PrivateConstructorForUtilityClass::isInstance)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().merge(SuggestedFixes.addMembers(classTree, state, ASTHelpers.createPrivateConstructor(classTree), new String[0]));
        SuggestedFixes.addModifiers((Tree)classTree, state, Modifier.FINAL).ifPresent(fix::merge);
        return this.describeMatch(classTree, (Fix)fix.build());
    }

    private static boolean isInPrivateScope(VisitorState state) {
        return Streams.stream(state.getPath()).anyMatch(currentLeaf -> currentLeaf instanceof ClassTree && ((ClassTree)currentLeaf).getModifiers().getFlags().contains((Object)Modifier.PRIVATE));
    }

    private static boolean isInstance(Tree tree) {
        switch (tree.getKind()) {
            case CLASS: {
                return !((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case METHOD: {
                return !((MethodTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case VARIABLE: {
                return !((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case BLOCK: {
                return !((BlockTree)tree).isStatic();
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
        }
        if (tree.getKind().name().equals("RECORD")) {
            return false;
        }
        throw new AssertionError((Object)("unknown member type:" + tree.getKind()));
    }
}

