/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@BugPattern(summary="Protobuf fields cannot be null.", severity=BugPattern.SeverityLevel.ERROR)
public class ProtoFieldNullComparison
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> CHECK_NOT_NULL = Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.base.Verify").named("verifyNotNull"), Matchers.staticMethod().onClass("java.util.Objects").named("requireNonNull"));
    private static final Matcher<ExpressionTree> ASSERT_NOT_NULL = Matchers.anyOf(Matchers.staticMethod().onClass("junit.framework.Assert").named("assertNotNull"), Matchers.staticMethod().onClass("org.junit.Assert").named("assertNotNull"));
    private static final Matcher<MethodInvocationTree> TRUTH_NOT_NULL = Matchers.allOf(Matchers.instanceMethod().anyClass().named("isNotNull"), Matchers.receiverOfInvocation(Matchers.anyOf(Matchers.staticMethod().anyClass().namedAnyOf("assertThat"), Matchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that"))));
    private static final Matcher<Tree> RETURNS_LIST = Matchers.isSubtypeOf("java.util.List");
    private static final ImmutableSet<Tree.Kind> COMPARISON_OPERATORS = Sets.immutableEnumSet((Enum)Tree.Kind.EQUAL_TO, (Enum[])new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO});
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_FIX = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters("com.google.protobuf.ExtensionLite", new String[0]);
    private static final Matcher<ExpressionTree> EXTENSION_METHODS_WITH_NO_FIX = Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getRepeatedField").withParameters("com.google.protobuf.Descriptors.FieldDescriptor", "int"), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage.ExtendableMessage").named("getExtension").withParameters("com.google.protobuf.ExtensionLite", "int"), Matchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageOrBuilder").named("getField").withParameters("com.google.protobuf.Descriptors.FieldDescriptor", new String[0]));
    private static final Matcher<ExpressionTree> OF_NULLABLE = Matchers.anyOf(Matchers.staticMethod().onClass("java.util.Optional").named("ofNullable"), Matchers.staticMethod().onClass("com.google.common.base.Optional").named("fromNullable"));
    private static final Matcher<ExpressionTree> PROTO_RECEIVER = Matchers.instanceMethod().onDescendantOfAny("com.google.protobuf.GeneratedMessageLite", "com.google.protobuf.GeneratedMessage");
    private final boolean matchTestAssertions;
    private static final Supplier<Symbol> COM_GOOGLE_PROTOBUF_EXTENSIONLITE = VisitorState.memoize(state -> state.getSymbolFromString("com.google.protobuf.ExtensionLite"));

    private static boolean isNull(ExpressionTree tree) {
        return tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    public ProtoFieldNullComparison(ErrorProneFlags flags) {
        this.matchTestAssertions = flags.getBoolean("ProtoFieldNullComparison:MatchTestAssertions").orElse(true);
    }

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ProtoNullComparisonScanner scanner = new ProtoNullComparisonScanner(state);
        scanner.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static String getMethodName(ExpressionTree tree) {
        MethodInvocationTree method = (MethodInvocationTree)tree;
        ExpressionTree expressionTree = method.getMethodSelect();
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
        return access.sym.getQualifiedName().toString();
    }

    private static String replaceLast(String text, String pattern, String replacement) {
        StringBuilder builder = new StringBuilder(text);
        int lastIndexOf = builder.lastIndexOf(pattern);
        return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
    }

    private static enum ProblemUsage {
        COMPARISON{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                Optional<String> replacement = fixer.getHazzer(tree.getKind() == Tree.Kind.EQUAL_TO, state);
                return replacement.map(r -> SuggestedFix.replace(tree, r)).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        TRUTH{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                return fixer.getHazzer(false, state).map(r -> {
                    MethodInvocationTree receiver = (MethodInvocationTree)ASTHelpers.getReceiver(tree);
                    return SuggestedFix.replace(tree, String.format("%s(%s).isTrue()", state.getSourceForNode(receiver.getMethodSelect()), r));
                }).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        JUNIT{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                return fixer.getHazzer(false, state).map(r -> {
                    int startPos = ASTHelpers.getStartPosition(methodInvocationTree);
                    return SuggestedFix.builder().replace(Iterables.getLast(methodInvocationTree.getArguments()), (String)r).replace(startPos, startPos + "assertNotNull".length(), "assertTrue").build();
                }).orElse(SuggestedFix.emptyFix());
            }
        }
        ,
        CHECK_NOT_NULL{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                Tree parent = state.getPath().getParentPath().getLeaf();
                return parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT ? SuggestedFix.delete(parent) : SuggestedFix.replace(tree, state.getSourceForNode(methodInvocationTree.getArguments().get(0)));
            }
        }
        ,
        OPTIONAL{

            @Override
            SuggestedFix fix(Fixer fixer, ExpressionTree tree, VisitorState state) {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                return SuggestedFixes.renameMethodInvocation(methodInvocationTree, "of", state);
            }
        };


        abstract SuggestedFix fix(Fixer var1, ExpressionTree var2, VisitorState var3);
    }

    private static enum GetterTypes {
        SCALAR{

            @Override
            @Nullable
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (RETURNS_LIST.matches(method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (n, s) -> this.generateFix(method, n, s) : null;
            }

            private Optional<String> generateFix(MethodInvocationTree methodInvocation, boolean negated, VisitorState state) {
                String methodName = ASTHelpers.getSymbol(methodInvocation).getQualifiedName().toString();
                String hasMethod = methodName.replaceFirst("get", "has");
                ImmutableSet<Symbol.MethodSymbol> hasMethods = ASTHelpers.findMatchingMethods(state.getName(hasMethod), ms -> ms.params().isEmpty(), ASTHelpers.getType(ASTHelpers.getReceiver(methodInvocation)), state.getTypes());
                if (hasMethods.isEmpty()) {
                    return Optional.empty();
                }
                String replacement = this.replaceLast(state.getSourceForNode(methodInvocation), methodName, hasMethod);
                return Optional.of(negated ? "!" + replacement : replacement);
            }

            private String replaceLast(String text, String pattern, String replacement) {
                StringBuilder builder = new StringBuilder(text);
                int lastIndexOf = builder.lastIndexOf(pattern);
                return builder.replace(lastIndexOf, lastIndexOf + pattern.length(), replacement).toString();
            }
        }
        ,
        VECTOR_INDEXED{

            @Override
            @Nullable
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (method.getArguments().size() != 1 || !GetterTypes.isGetter(method.getMethodSelect())) {
                    return null;
                }
                if (!ASTHelpers.isSameType(ASTHelpers.getType(Iterables.getOnlyElement(method.getArguments())), state.getSymtab().intType, state)) {
                    return null;
                }
                return (n, s) -> Optional.of(this.generateFix(method, n, state));
            }

            private String generateFix(MethodInvocationTree methodInvocation, boolean negated, VisitorState visitorState) {
                String methodName = ASTHelpers.getSymbol(methodInvocation).getQualifiedName().toString();
                String countMethod = methodName + "Count";
                return String.format("%s.%s() %s %s", visitorState.getSourceForNode(ASTHelpers.getReceiver(methodInvocation)), countMethod, negated ? "<=" : ">", visitorState.getSourceForNode(Iterables.getOnlyElement(methodInvocation.getArguments())));
            }
        }
        ,
        VECTOR{

            @Override
            @Nullable
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
                    return null;
                }
                MethodInvocationTree method = (MethodInvocationTree)tree;
                if (!method.getArguments().isEmpty()) {
                    return null;
                }
                if (!RETURNS_LIST.matches(method, state)) {
                    return null;
                }
                ExpressionTree expressionTree = method.getMethodSelect();
                return GetterTypes.isGetter(expressionTree) ? (n, s) -> Optional.of(this.generateFix(n, method, state)) : null;
            }

            private String generateFix(boolean negated, ExpressionTree methodInvocation, VisitorState state) {
                String replacement = state.getSourceForNode(methodInvocation) + ".isEmpty()";
                return negated ? replacement : "!" + replacement;
            }
        }
        ,
        EXTENSION_METHOD{

            @Override
            @Nullable
            Fixer match(ExpressionTree tree, VisitorState state) {
                if (EXTENSION_METHODS_WITH_NO_FIX.matches(tree, state)) {
                    return (x$0, x$1) -> GetterTypes.emptyFix(x$0, x$1);
                }
                if (EXTENSION_METHODS_WITH_FIX.matches(tree, state)) {
                    MethodInvocationTree methodInvocation = (MethodInvocationTree)tree;
                    Type argumentType = ASTHelpers.getType(Iterables.getOnlyElement(methodInvocation.getArguments()));
                    Symbol extension = COM_GOOGLE_PROTOBUF_EXTENSIONLITE.get(state);
                    Type genericsArgument = state.getTypes().asSuper(argumentType, extension);
                    if (genericsArgument.getTypeArguments().size() != 2) {
                        return (x$0, x$1) -> GetterTypes.emptyFix(x$0, x$1);
                    }
                    if (ASTHelpers.isSubtype(genericsArgument.getTypeArguments().get(1), state.getSymtab().listType, state)) {
                        return (x$0, x$1) -> GetterTypes.emptyFix(x$0, x$1);
                    }
                    return this.generateFix(methodInvocation);
                }
                return null;
            }

            private Fixer generateFix(MethodInvocationTree methodInvocation) {
                return (negated, state) -> {
                    String methodName = ProtoFieldNullComparison.getMethodName(methodInvocation);
                    String hasMethod = methodName.replaceFirst("get", "has");
                    String replacement = ProtoFieldNullComparison.replaceLast(state.getSourceForNode(methodInvocation), methodName, hasMethod);
                    return Optional.of(negated ? "!" + replacement : replacement);
                };
            }
        };


        private static Optional<String> emptyFix(boolean n, VisitorState s) {
            return Optional.empty();
        }

        private static boolean isGetter(ExpressionTree expressionTree) {
            if (!(expressionTree instanceof JCTree.JCFieldAccess)) {
                return false;
            }
            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
            String methodName = access.sym.getQualifiedName().toString();
            return methodName.startsWith("get");
        }

        abstract Fixer match(ExpressionTree var1, VisitorState var2);
    }

    @FunctionalInterface
    private static interface Fixer {
        public Optional<String> getHazzer(boolean var1, VisitorState var2);
    }

    private class ProtoNullComparisonScanner
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, ExpressionTree> effectivelyFinalValues = new HashMap<Symbol, ExpressionTree>();
        private final VisitorState state;

        private ProtoNullComparisonScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitMethod(MethodTree method, Void unused) {
            return ProtoFieldNullComparison.this.isSuppressed(method, this.state) ? null : (Void)super.visitMethod(method, unused);
        }

        @Override
        public Void visitClass(ClassTree clazz, Void unused) {
            return ProtoFieldNullComparison.this.isSuppressed(clazz, this.state) ? null : (Void)super.visitClass(clazz, unused);
        }

        @Override
        public Void visitVariable(VariableTree variable, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol(variable);
            if (variable.getInitializer() != null && ASTHelpers.isConsideredFinal(symbol)) {
                this.getInitializer(variable.getInitializer()).ifPresent(e -> this.effectivelyFinalValues.put(symbol, (ExpressionTree)e));
            }
            return ProtoFieldNullComparison.this.isSuppressed(variable, this.state) ? null : (Void)super.visitVariable(variable, null);
        }

        private Optional<ExpressionTree> getInitializer(ExpressionTree tree) {
            return Optional.ofNullable((ExpressionTree)new SimpleTreeVisitor<ExpressionTree, Void>(){

                @Override
                @Nullable
                public ExpressionTree visitMethodInvocation(MethodInvocationTree node, Void unused) {
                    return PROTO_RECEIVER.matches(node, ProtoNullComparisonScanner.this.state) ? node : null;
                }

                @Override
                public ExpressionTree visitParenthesized(ParenthesizedTree node, Void unused) {
                    return (ExpressionTree)this.visit(node.getExpression(), null);
                }

                @Override
                public ExpressionTree visitTypeCast(TypeCastTree node, Void unused) {
                    return (ExpressionTree)this.visit(node.getExpression(), null);
                }
            }.visit(tree, null));
        }

        @Override
        public Void visitBinary(BinaryTree binary, Void unused) {
            if (!COMPARISON_OPERATORS.contains((Object)binary.getKind())) {
                return (Void)super.visitBinary(binary, null);
            }
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            Optional<Fixer> fixer = Optional.empty();
            if (ProtoFieldNullComparison.isNull(binary.getLeftOperand())) {
                fixer = this.getFixer(binary.getRightOperand(), subState);
            }
            if (ProtoFieldNullComparison.isNull(binary.getRightOperand())) {
                fixer = this.getFixer(binary.getLeftOperand(), subState);
            }
            fixer.map(f -> ProtoFieldNullComparison.this.describeMatch(binary, (Fix)ProblemUsage.COMPARISON.fix((Fixer)f, binary, subState))).ifPresent(this.state::reportMatch);
            return (Void)super.visitBinary(binary, null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            ProblemUsage problemType;
            ExpressionTree argument;
            VisitorState subState = this.state.withPath(this.getCurrentPath());
            if (CHECK_NOT_NULL.matches(node, subState)) {
                argument = node.getArguments().get(0);
                problemType = ProblemUsage.CHECK_NOT_NULL;
            } else if (ProtoFieldNullComparison.this.matchTestAssertions && ASSERT_NOT_NULL.matches(node, subState)) {
                argument = Iterables.getLast(node.getArguments());
                problemType = ProblemUsage.JUNIT;
            } else if (OF_NULLABLE.matches(node, subState)) {
                argument = Iterables.getOnlyElement(node.getArguments());
                problemType = ProblemUsage.OPTIONAL;
            } else if (ProtoFieldNullComparison.this.matchTestAssertions && TRUTH_NOT_NULL.matches(node, subState)) {
                argument = Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver(node)).getArguments());
                problemType = ProblemUsage.TRUTH;
            } else {
                return (Void)super.visitMethodInvocation(node, null);
            }
            this.getFixer(argument, subState).map(f -> problemType.fix((Fixer)f, node, subState)).filter(f -> !f.isEmpty()).map(f -> ProtoFieldNullComparison.this.describeMatch(node, (Fix)f)).ifPresent(this.state::reportMatch);
            return (Void)super.visitMethodInvocation(node, null);
        }

        private Optional<Fixer> getFixer(ExpressionTree tree, VisitorState state) {
            ExpressionTree resolvedTree = this.getEffectiveTree(tree);
            if (resolvedTree == null || !PROTO_RECEIVER.matches(resolvedTree, state)) {
                return Optional.empty();
            }
            return Arrays.stream(GetterTypes.values()).map(type -> type.match(resolvedTree, state)).filter(Objects::nonNull).findFirst();
        }

        @Nullable
        private ExpressionTree getEffectiveTree(ExpressionTree tree) {
            return tree.getKind() == Tree.Kind.IDENTIFIER ? this.effectivelyFinalValues.get(ASTHelpers.getSymbol(tree)) : tree;
        }
    }
}

