/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@BugPattern(summary="Thrown exception is a subtype of another", severity=BugPattern.SeverityLevel.WARNING)
public class RedundantThrows
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<? extends ExpressionTree> thrown = tree.getThrows();
        if (thrown.isEmpty()) {
            return Description.NO_MATCH;
        }
        LinkedHashMultimap<Symbol.TypeSymbol, ExpressionTree> exceptionsBySuper = LinkedHashMultimap.create();
        for (ExpressionTree expressionTree : thrown) {
            Object type = ASTHelpers.getType(expressionTree);
            do {
                type = state.getTypes().supertype((Type)type);
                exceptionsBySuper.put(((Type)type).tsym, expressionTree);
            } while (!state.getTypes().isSameType((Type)type, state.getSymtab().objectType));
        }
        HashSet toRemove = new HashSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ExpressionTree expressionTree : thrown) {
            Symbol sym = ASTHelpers.getSymbol(expressionTree);
            if (!exceptionsBySuper.containsKey(sym)) continue;
            Collection sub = exceptionsBySuper.get(sym);
            arrayList.add(String.format("%s %s of %s", RedundantThrows.oxfordJoin(", ", sub), sub.size() == 1 ? "is a subtype" : "are subtypes", sym.getSimpleName()));
            toRemove.addAll(sub);
        }
        if (toRemove.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableList<ExpressionTree> delete = ImmutableList.copyOf(Iterables.filter(tree.getThrows(), Predicates.in(toRemove)));
        return this.buildDescription((Tree)delete.get(0)).setMessage("Redundant throws clause: " + RedundantThrows.oxfordJoin("; ", arrayList)).addFix(SuggestedFixes.deleteExceptions(tree, state, delete)).build();
    }

    static String oxfordJoin(String on, Iterable<?> pieces) {
        StringBuilder result = new StringBuilder();
        int size = Iterables.size(pieces);
        if (size == 2) {
            return Joiner.on(" and ").join(pieces);
        }
        int idx = 0;
        for (Object piece : pieces) {
            if (idx > 0) {
                result.append(on);
                if (idx == size - 1) {
                    result.append("and ");
                }
            }
            result.append(piece);
            ++idx;
        }
        return result.toString();
    }
}

