/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="This type name shadows another in a way that may be confusing.", severity=BugPattern.SeverityLevel.WARNING)
public final class SameNameButDifferent
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashBasedTable table = HashBasedTable.create();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                if (!this.shouldIgnore()) {
                    this.handle(memberSelectTree);
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                if (this.shouldIgnore()) {
                    return null;
                }
                if (!(ASTHelpers.getSymbol(identifierTree) instanceof Symbol.ClassSymbol)) {
                    return null;
                }
                TreePath enclosingClass = ASTHelpers.findPathFromEnclosingNodeToTopLevel(this.getCurrentPath(), ClassTree.class);
                if (enclosingClass != null && ASTHelpers.getSymbol(enclosingClass.getLeaf()) == ASTHelpers.getSymbol(identifierTree)) {
                    return null;
                }
                this.handle(identifierTree);
                return null;
            }

            private boolean shouldIgnore() {
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                return parentTree instanceof MemberSelectTree && ASTHelpers.getSymbol(parentTree) instanceof Symbol.ClassSymbol;
            }

            private @Nullable String qualifiedName(Tree tree) {
                if (state.getEndPosition(tree) == -1) {
                    return null;
                }
                ArrayDeque<Name> parts = new ArrayDeque<Name>();
                while (tree instanceof MemberSelectTree) {
                    MemberSelectTree select = (MemberSelectTree)tree;
                    parts.addFirst(select.getIdentifier());
                    tree = select.getExpression();
                }
                if (!(tree instanceof IdentifierTree)) {
                    return null;
                }
                parts.addFirst(((IdentifierTree)tree).getName());
                return Joiner.on('.').join(parts);
            }

            private void handle(Tree tree) {
                if (tree instanceof IdentifierTree && ((IdentifierTree)tree).getName().contentEquals("Builder")) {
                    return;
                }
                String qualifiedName = this.qualifiedName(tree);
                if (qualifiedName == null) {
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol(tree);
                if (symbol instanceof Symbol.ClassSymbol) {
                    ArrayList<TreePath> treePaths = (ArrayList<TreePath>)table.get(qualifiedName, symbol.type.tsym);
                    if (treePaths == null) {
                        treePaths = new ArrayList<TreePath>();
                        table.put(qualifiedName, symbol.type.tsym, treePaths);
                    }
                    treePaths.add(this.getCurrentPath());
                }
            }
        }.scan(state.getPath(), null);
        HashBasedTable<String, Symbol.TypeSymbol, List> trimmedTable = HashBasedTable.create();
        for (Map.Entry row : table.rowMap().entrySet()) {
            Map columns = row.getValue();
            if (columns.size() <= 1) continue;
            for (Map.Entry cell : columns.entrySet()) {
                if (!((List)cell.getValue()).stream().anyMatch(treePath -> SameNameButDifferent.shadowsClass(state, treePath))) continue;
                trimmedTable.put((String)row.getKey(), (Symbol.TypeSymbol)cell.getKey(), (List)cell.getValue());
            }
        }
        for (Map.Entry row : trimmedTable.rowMap().entrySet()) {
            String simpleName = (String)row.getKey();
            Map columns = row.getValue();
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (columns.size() <= 1) continue;
            for (Map.Entry cell : columns.entrySet()) {
                for (TreePath treePath2 : (List)cell.getValue()) {
                    Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)cell.getKey();
                    SameNameButDifferent.getBetterImport(typeSymbol, simpleName).ifPresent(imp -> {
                        String qualifiedName = SameNameButDifferent.qualifyType(state.withPath(treePath2), fix, imp);
                        String newSimpleName = qualifiedName + "." + simpleName;
                        fix.replace(treePath2.getLeaf(), newSimpleName);
                    });
                }
            }
            String message = String.format("The name `%s` refers to %s within this file. It may be confusing to have the same name refer to multiple types. Consider qualifying them for clarity.", simpleName, columns.keySet().stream().map(t -> t.getQualifiedName().toString()).collect(Collectors.joining(", ", "[", "]")));
            for (List treePaths : trimmedTable.row(simpleName).values()) {
                for (TreePath treePath3 : treePaths) {
                    state.reportMatch(this.buildDescription(treePath3.getLeaf()).setMessage(message).addFix(fix.build()).build());
                }
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean shadowsClass(VisitorState state, TreePath treePath) {
        if (!(treePath.getLeaf() instanceof IdentifierTree)) {
            return true;
        }
        TreePath enclosingClass = ASTHelpers.findPathFromEnclosingNodeToTopLevel(treePath, ClassTree.class);
        String name = ((IdentifierTree)treePath.getLeaf()).getName().toString();
        return FindIdentifiers.findIdent(name, state.withPath(enclosingClass), Kinds.KindSelector.VAL_TYP) != null;
    }

    private static Optional<Symbol> getBetterImport(Symbol.TypeSymbol classSymbol, String simpleName) {
        Symbol owner = classSymbol;
        long dots = simpleName.chars().filter(c -> c == 46).count();
        for (long i = 0L; i < dots + 1L; ++i) {
            if (owner == null) {
                return Optional.empty();
            }
            owner = owner.owner;
        }
        if (owner instanceof Symbol.ClassSymbol) {
            return Optional.of(owner);
        }
        return Optional.empty();
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, Symbol sym) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        Symbol curr = sym;
        while (curr != null) {
            names.addFirst(curr.getSimpleName().toString());
            Symbol found = FindIdentifiers.findIdent(curr.getSimpleName().toString(), state, Kinds.KindSelector.VAL_TYP);
            if (found == curr) break;
            if (curr.getKind() == ElementKind.PACKAGE) {
                return sym.getQualifiedName().toString();
            }
            if (found == null) {
                fix.addImport(curr.getQualifiedName().toString());
                break;
            }
            curr = curr.owner;
        }
        return Joiner.on('.').join(names);
    }
}

