/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="An object is compared to itself", severity=BugPattern.SeverityLevel.ERROR)
public class SelfComparison
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> COMPARE_TO_MATCHER = Matchers.allOf(Matchers.instanceMethod().onDescendantOf("java.lang.Comparable").named("compareTo"), Matchers.receiverSameAsArgument(0));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!COMPARE_TO_MATCHER.matches(methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodInvocationTree);
    }
}

