/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(summary="Testing an object for equality with itself will always be true.", severity=BugPattern.SeverityLevel.ERROR)
public class SelfEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<Tree> ASSERTION = Matchers.toType(MethodInvocationTree.class, MethodMatchers.staticMethod().anyClass().namedAnyOf("assertTrue", "assertThat"));
    private static final Matcher<MethodInvocationTree> INSTANCE_MATCHER = Matchers.allOf(Matchers.instanceEqualsInvocation(), Matchers.receiverSameAsArgument(0));
    private static final Matcher<MethodInvocationTree> STATIC_MATCHER = Matchers.allOf(Matchers.staticEqualsInvocation(), Matchers.sameArgument(0, 1));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree toReplace;
        if (ASSERTION.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> args = tree.getArguments();
        if (INSTANCE_MATCHER.matches(tree, state)) {
            toReplace = args.get(0);
        } else if (STATIC_MATCHER.matches(tree, state)) {
            toReplace = args.get(0).getKind() == Tree.Kind.IDENTIFIER && args.get(1).getKind() != Tree.Kind.IDENTIFIER ? args.get(0) : args.get(1);
        } else {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        Fix fix = SelfEquals.fieldFix(toReplace, state);
        if (fix != null) {
            description.addFix(fix);
        }
        return description.build();
    }

    @Nullable
    protected static Fix fieldFix(Tree toReplace, VisitorState state) {
        TreePath path;
        for (path = state.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.BLOCK; path = path.getParentPath()) {
        }
        if (path == null) {
            return null;
        }
        List members = path.getLeaf().getKind() == Tree.Kind.CLASS ? ((JCTree.JCClassDecl)path.getLeaf()).getMembers() : ((JCTree.JCBlock)path.getLeaf()).getStatements();
        for (JCTree jcTree : members) {
            if (jcTree.getKind() != Tree.Kind.VARIABLE) continue;
            JCTree.JCVariableDecl declaration = (JCTree.JCVariableDecl)jcTree;
            Symbol.TypeSymbol variableTypeSymbol = state.getTypes().erasure((Type)ASTHelpers.getType((Tree)declaration)).tsym;
            if (!ASTHelpers.getSymbol(toReplace).isMemberOf(variableTypeSymbol, state.getTypes())) continue;
            if (toReplace.getKind() == Tree.Kind.IDENTIFIER) {
                return SuggestedFix.prefixWith(toReplace, declaration.getName() + ".");
            }
            return SuggestedFix.replace(((JCTree.JCFieldAccess)toReplace).getExpression(), declaration.getName().toString());
        }
        return null;
    }
}

