/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(summary="This method must be called with an even number of arguments.", severity=BugPattern.SeverityLevel.ERROR)
public class ShouldHaveEvenArgs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.instanceMethod().onDescendantOfAny("com.google.common.truth.MapSubject", "com.google.common.truth.MapSubject.UsingCorrespondence", "com.google.common.truth.MultimapSubject", "com.google.common.truth.MultimapSubject.UsingCorrespondence").named("containsExactly");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!MATCHER.matches(methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (methodInvocationTree.getArguments().size() % 2 == 0) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(methodInvocationTree);
        if (!methodSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        Type varArgsArrayType = Iterables.getLast(methodSymbol.params()).type;
        Type lastArgType = ASTHelpers.getType(Iterables.getLast(arguments));
        if (arguments.size() == methodSymbol.params().size() && ASTHelpers.isSameType(varArgsArrayType, lastArgType, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodInvocationTree);
    }
}

