/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.collect.Table;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BugPattern(summary="Comparison of a size >= 0 is always true, did you intend to check for non-emptiness?", severity=BugPattern.SeverityLevel.ERROR)
public class SizeGreaterThanOrEqualsZero
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final ImmutableTable<String, MethodName, Boolean> CLASSES = ImmutableTable.builder().put("android.util.LongSparseArray", MethodName.SIZE, false).put("android.util.LruCache", MethodName.SIZE, false).put("android.util.SparseArray", MethodName.SIZE, false).put("android.util.SparseBooleanArray", MethodName.SIZE, false).put("android.util.SparseIntArray", MethodName.SIZE, false).put("android.util.SparseLongArray", MethodName.SIZE, false).put("androidx.collection.CircularArray", MethodName.SIZE, true).put("androidx.collection.CircularIntArray", MethodName.SIZE, true).put("androidx.collection.LongSparseArray", MethodName.SIZE, false).put("androidx.collection.LruCache", MethodName.SIZE, false).put("androidx.collection.SimpleArrayMap", MethodName.SIZE, true).put("androidx.collection.SparseArrayCompat", MethodName.SIZE, false).put("com.google.common.collect.FluentIterable", MethodName.SIZE, true).put("com.google.common.collect.Multimap", MethodName.SIZE, true).put("java.io.ByteArrayOutputStream", MethodName.SIZE, false).put("java.util.Collection", MethodName.SIZE, true).put("java.util.Dictionary", MethodName.SIZE, true).put("java.util.Map", MethodName.SIZE, true).put("java.util.BitSet", MethodName.LENGTH, true).put("java.lang.CharSequence", MethodName.LENGTH, false).put("java.lang.String", MethodName.LENGTH, true).put("java.lang.StringBuilder", MethodName.LENGTH, false).put("java.lang.StringBuffer", MethodName.LENGTH, false).buildOrThrow();
    private static final ImmutableTable<String, MethodName, Boolean> STATIC_CLASSES = ImmutableTable.builder().put("com.google.common.collect.Iterables", MethodName.SIZE, true).buildOrThrow();
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> SIZE_OR_LENGTH_INSTANCE_METHOD = Matchers.anyOf(Matchers.instanceMethod().onDescendantOfAny(((ImmutableMap)CLASSES.column((Object)MethodName.SIZE)).keySet()).named("size"), Matchers.instanceMethod().onDescendantOfAny(((ImmutableMap)CLASSES.column((Object)MethodName.LENGTH)).keySet()).named("length"));
    private static final Pattern PROTO_COUNT_METHOD_PATTERN = Pattern.compile("get(.+)Count");
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> PROTO_METHOD_NAMED_GET_COUNT = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage").withNameMatching(PROTO_COUNT_METHOD_PATTERN).withNoParameters();
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> PROTO_REPEATED_FIELD_COUNT_METHOD = SizeGreaterThanOrEqualsZero::isProtoRepeatedFieldCountMethod;
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> SIZE_OR_LENGTH_STATIC_METHOD = Matchers.anyOf(Streams.concat(((ImmutableMap)STATIC_CLASSES.column((Object)MethodName.SIZE)).keySet().stream().map(className -> Matchers.staticMethod().onClass((String)className).named("size")), ((ImmutableMap)STATIC_CLASSES.column((Object)MethodName.LENGTH)).keySet().stream().map(className -> Matchers.staticMethod().onClass((String)className).named("length"))).collect(ImmutableList.toImmutableList()));
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> HAS_EMPTY_METHOD = SizeGreaterThanOrEqualsZero.classHasIsEmptyFunction();

    private static boolean arrayLengthMatcher(MemberSelectTree tree, VisitorState state) {
        return ASTHelpers.getSymbol(tree) == state.getSymtab().lengthVar;
    }

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        ExpressionTree operand;
        ExpressionType expressionType = SizeGreaterThanOrEqualsZero.isGreaterThanEqualToZero(tree);
        if (expressionType == ExpressionType.MISMATCH) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = operand = expressionType == ExpressionType.GREATER_THAN_EQUAL ? tree.getLeftOperand() : tree.getRightOperand();
        if (operand instanceof MethodInvocationTree) {
            MethodInvocationTree callToSize = (MethodInvocationTree)operand;
            if (SIZE_OR_LENGTH_INSTANCE_METHOD.matches(callToSize, state)) {
                return this.provideReplacementForInstanceMethodInvocation(tree, callToSize, state, expressionType);
            }
            if (SIZE_OR_LENGTH_STATIC_METHOD.matches(callToSize, state)) {
                return this.provideReplacementForStaticMethodInvocation(tree, callToSize, state, expressionType);
            }
            if (PROTO_REPEATED_FIELD_COUNT_METHOD.matches(callToSize, state)) {
                return this.provideReplacementForProtoMethodInvocation(tree, callToSize, state);
            }
        } else if (operand instanceof MemberSelectTree && SizeGreaterThanOrEqualsZero.arrayLengthMatcher((MemberSelectTree)operand, state)) {
            return this.removeEqualsFromComparison(tree, state, expressionType);
        }
        return Description.NO_MATCH;
    }

    private static boolean isProtoRepeatedFieldCountMethod(ExpressionTree tree, VisitorState state) {
        if (!PROTO_METHOD_NAMED_GET_COUNT.matches(tree, state)) {
            return false;
        }
        Symbol.MethodSymbol methodCallSym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        Scope.WriteableScope protoClassMembers = methodCallSym.owner.members();
        Matcher getCountRegexMatcher = PROTO_COUNT_METHOD_PATTERN.matcher(((Name)methodCallSym.getSimpleName()).toString());
        if (!getCountRegexMatcher.matches()) {
            return false;
        }
        String fieldName = getCountRegexMatcher.group(1);
        return protoClassMembers.findFirst(state.getName("get" + fieldName + "List")) != null;
    }

    private static com.google.errorprone.matchers.Matcher<ExpressionTree> classHasIsEmptyFunction() {
        ImmutableList.Builder classNames = ImmutableList.builder();
        for (Table.Cell methodInformation : Iterables.concat(CLASSES.cellSet(), STATIC_CLASSES.cellSet())) {
            if (!((Boolean)methodInformation.getValue()).booleanValue()) continue;
            classNames.add((String)methodInformation.getRowKey());
        }
        return Matchers.anyOf(classNames.build().stream().map(Matchers::isSubtypeOf).collect(ImmutableList.toImmutableList()));
    }

    private Description provideReplacementForInstanceMethodInvocation(BinaryTree tree, MethodInvocationTree leftOperand, VisitorState state, ExpressionType expressionType) {
        ExpressionTree collection = ASTHelpers.getReceiver(leftOperand);
        if (HAS_EMPTY_METHOD.matches(collection, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, "!" + state.getSourceForNode(collection) + ".isEmpty()"));
        }
        return this.removeEqualsFromComparison(tree, state, expressionType);
    }

    private Description provideReplacementForStaticMethodInvocation(BinaryTree tree, MethodInvocationTree callToSize, VisitorState state, ExpressionType expressionType) {
        ExpressionTree classToken = ASTHelpers.getReceiver(callToSize);
        if (HAS_EMPTY_METHOD.matches(classToken, state)) {
            String argumentString = callToSize.getArguments().stream().map(state::getSourceForNode).collect(Collectors.joining(","));
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, "!" + state.getSourceForNode(classToken) + ".isEmpty(" + argumentString + ")"));
        }
        return this.removeEqualsFromComparison(tree, state, expressionType);
    }

    private Description provideReplacementForProtoMethodInvocation(BinaryTree tree, MethodInvocationTree protoGetSize, VisitorState state) {
        String expSrc = state.getSourceForNode(protoGetSize);
        Matcher protoGetCountMatcher = PROTO_COUNT_METHOD_PATTERN.matcher(expSrc);
        if (!protoGetCountMatcher.find()) {
            throw new AssertionError((Object)(state.getSourceForNode(protoGetSize) + " does not contain a get<RepeatedField>Count method"));
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, "!" + protoGetCountMatcher.replaceFirst("get" + protoGetCountMatcher.group(1) + "List") + ".isEmpty()"));
    }

    private Description removeEqualsFromComparison(BinaryTree tree, VisitorState state, ExpressionType expressionType) {
        String replacement = expressionType == ExpressionType.GREATER_THAN_EQUAL ? state.getSourceForNode(tree.getLeftOperand()) + " > 0" : "0 < " + state.getSourceForNode(tree.getRightOperand());
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, replacement));
    }

    private static ExpressionType isGreaterThanEqualToZero(BinaryTree tree) {
        ExpressionType returnType;
        ExpressionTree literalOperand;
        switch (tree.getKind()) {
            case GREATER_THAN_EQUAL: {
                literalOperand = tree.getRightOperand();
                returnType = ExpressionType.GREATER_THAN_EQUAL;
                break;
            }
            case LESS_THAN_EQUAL: {
                literalOperand = tree.getLeftOperand();
                returnType = ExpressionType.LESS_THAN_EQUAL;
                break;
            }
            default: {
                return ExpressionType.MISMATCH;
            }
        }
        if (literalOperand.getKind() != Tree.Kind.INT_LITERAL) {
            return ExpressionType.MISMATCH;
        }
        if (!((LiteralTree)literalOperand).getValue().equals(0)) {
            return ExpressionType.MISMATCH;
        }
        return returnType;
    }

    private static enum ExpressionType {
        LESS_THAN_EQUAL,
        GREATER_THAN_EQUAL,
        MISMATCH;

    }

    private static enum MethodName {
        LENGTH,
        SIZE;

    }
}

