/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Using stream::iterator creates a one-shot Iterable, which may cause surprising failures.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, documentSuppression=false)
public final class StreamToIterable
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<ExpressionTree> STREAM_ITERATOR = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.Stream").named("iterator");

    @Override
    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (!ASTHelpers.isSameType(ASTHelpers.getType(tree), state.getSymtab().iterableType, state)) {
            return Description.NO_MATCH;
        }
        if (!tree.getBodyKind().equals((Object)LambdaExpressionTree.BodyKind.EXPRESSION)) {
            return Description.NO_MATCH;
        }
        ExpressionTree body = (ExpressionTree)tree.getBody();
        if (!STREAM_ITERATOR.matches(body, state)) {
            return Description.NO_MATCH;
        }
        if (!(ASTHelpers.getSymbol(ASTHelpers.getReceiver(body)) instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, body, state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!STREAM_ITERATOR.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(ASTHelpers.getType(tree), state.getSymtab().iterableType, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, tree, state);
    }

    private Description describeMatch(ExpressionTree tree, ExpressionTree invocation, VisitorState state) {
        if (state.getPath().getParentPath().getLeaf() instanceof TypeCastTree && state.getPath().getParentPath().getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("Collect to an ImmutableList (caveat: this materializes the contents into memory at once)");
        fix.replace(tree, String.format("%s.collect(%s())", state.getSourceForNode(ASTHelpers.getReceiver(invocation)), SuggestedFixes.qualifyStaticImport("com.google.common.collect.ImmutableList.toImmutableList", fix, state)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

