/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Regexes;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@BugPattern(summary="String.split(String) has surprising behavior", severity=BugPattern.SeverityLevel.WARNING)
public class StringSplitter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("split").withParameters("java.lang.String", new String[0]), MethodMatchers.instanceMethod().onExactClass("java.util.regex.Pattern").named("split").withParameters("java.lang.CharSequence", new String[0]));
    private static final Supplier<Type> JAVA_UTIL_REGEX_PATTERN = VisitorState.memoize(state -> state.getTypeFromString("java.util.regex.Pattern"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Optional<Fix> fix = this.buildFix(tree, state);
        if (!fix.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, fix.get());
    }

    public Optional<Fix> buildFix(MethodInvocationTree tree, final VisitorState state) {
        boolean isImplicitlyTyped;
        ExpressionTree arg = Iterables.getOnlyElement(tree.getArguments());
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof EnhancedForLoopTree && ((EnhancedForLoopTree)parent).getExpression().equals(tree)) {
            return Optional.of(StringSplitter.replaceWithSplitter(SuggestedFix.builder(), tree, arg, state, "split", false).build());
        }
        if (parent instanceof ArrayAccessTree) {
            ArrayAccessTree arrayAccessTree = (ArrayAccessTree)parent;
            if (!arrayAccessTree.getExpression().equals(tree)) {
                return Optional.empty();
            }
            SuggestedFix.Builder fix = SuggestedFix.builder().addImport("com.google.common.collect.Iterables").replace(ASTHelpers.getStartPosition(arrayAccessTree), ASTHelpers.getStartPosition(arrayAccessTree), "Iterables.get(").replace(state.getEndPosition(arrayAccessTree.getExpression()), ASTHelpers.getStartPosition(arrayAccessTree.getIndex()), String.format(", ", new Object[0])).replace(state.getEndPosition(arrayAccessTree.getIndex()), state.getEndPosition(arrayAccessTree), ")");
            return Optional.of(StringSplitter.replaceWithSplitter(fix, tree, arg, state, "split", false).build());
        }
        if (!(parent instanceof VariableTree)) {
            return Optional.empty();
        }
        VariableTree varTree = (VariableTree)parent;
        if (!varTree.getInitializer().equals(tree)) {
            return Optional.empty();
        }
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol(varTree);
        TreePath enclosing = StringSplitter.findEnclosing(state);
        if (enclosing == null) {
            return Optional.empty();
        }
        final ArrayList uses = new ArrayList();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (Objects.equals(sym, ASTHelpers.getSymbol(tree))) {
                    uses.add(this.getCurrentPath());
                }
                return (Void)super.visitIdentifier(tree, null);
            }
        }.scan(enclosing, (Void)null);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final boolean[] needsList = new boolean[]{false};
        final boolean[] needsMutableList = new boolean[]{false};
        for (TreePath path : uses) {
            class UseFixer
            extends TreePathScanner<Boolean, Void> {
                UseFixer() {
                }

                @Override
                public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void unused) {
                    return sym.equals(ASTHelpers.getSymbol(tree.getExpression()));
                }

                @Override
                public Boolean visitArrayAccess(ArrayAccessTree tree, Void unused) {
                    ExpressionTree expression = tree.getExpression();
                    ExpressionTree index = tree.getIndex();
                    if (!sym.equals(ASTHelpers.getSymbol(expression))) {
                        return false;
                    }
                    Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                    if (parent instanceof AssignmentTree && ((AssignmentTree)parent).getVariable() == tree) {
                        AssignmentTree assignmentTree = (AssignmentTree)parent;
                        fix.replace(state.getEndPosition(expression), ASTHelpers.getStartPosition(index), ".set(").replace(state.getEndPosition(index), ASTHelpers.getStartPosition(assignmentTree.getExpression()), ", ").postfixWith(assignmentTree, ")");
                        needsMutableList[0] = true;
                    } else {
                        fix.replace(state.getEndPosition(expression), ASTHelpers.getStartPosition(index), ".get(").replace(state.getEndPosition(index), state.getEndPosition(tree), ")");
                    }
                    needsList[0] = true;
                    return true;
                }

                @Override
                public Boolean visitMemberSelect(MemberSelectTree tree, Void unused) {
                    if (sym.equals(ASTHelpers.getSymbol(tree.getExpression())) && tree.getIdentifier().contentEquals("length")) {
                        fix.replace(state.getEndPosition(tree.getExpression()), state.getEndPosition(tree), ".size()");
                        needsList[0] = true;
                        return true;
                    }
                    return false;
                }
            }
            if (MoreObjects.firstNonNull((Boolean)new UseFixer().scan(path.getParentPath(), null), false).booleanValue()) continue;
            return Optional.empty();
        }
        Tree varType = varTree.getType();
        boolean bl = isImplicitlyTyped = ASTHelpers.getStartPosition(varType) < 0;
        if (needsList[0]) {
            if (!isImplicitlyTyped) {
                fix.replace(varType, "List<String>").addImport("java.util.List");
            }
            StringSplitter.replaceWithSplitter(fix, tree, arg, state, "splitToList", needsMutableList[0]);
        } else {
            if (!isImplicitlyTyped) {
                fix.replace(varType, "Iterable<String>");
            }
            StringSplitter.replaceWithSplitter(fix, tree, arg, state, "split", needsMutableList[0]);
        }
        return Optional.of(fix.build());
    }

    private static String getMethodAndArgument(Tree origArg, VisitorState state) {
        String argSource = state.getSourceForNode(origArg);
        Tree arg = ASTHelpers.stripParentheses(origArg);
        if (arg.getKind() != Tree.Kind.STRING_LITERAL) {
            return String.format("onPattern(%s)", argSource);
        }
        String constValue = ASTHelpers.constValue(arg, String.class);
        if (constValue == null) {
            return String.format("onPattern(%s)", argSource);
        }
        Optional<String> regexAsLiteral = Regexes.convertRegexToLiteral(constValue);
        if (!regexAsLiteral.isPresent()) {
            return String.format("onPattern(%s)", argSource);
        }
        String escaped = SourceCodeEscapers.javaCharEscaper().escape(regexAsLiteral.get());
        if (regexAsLiteral.get().length() == 1) {
            return String.format("on('%s')", escaped);
        }
        return String.format("on(\"%s\")", escaped);
    }

    private static SuggestedFix.Builder replaceWithSplitter(SuggestedFix.Builder fix, MethodInvocationTree tree, ExpressionTree arg, VisitorState state, String splitMethod, boolean mutableList) {
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (mutableList) {
            fix.addImport("java.util.ArrayList");
        }
        fix.addImport("com.google.common.base.Splitter");
        Type receiverType = ASTHelpers.getType(receiver);
        if (ASTHelpers.isSubtype(receiverType, state.getSymtab().stringType, state)) {
            String methodAndArgument = StringSplitter.getMethodAndArgument(arg, state);
            return fix.prefixWith(receiver, String.format("%sSplitter.%s.%s(", mutableList ? "new ArrayList<>(" : "", methodAndArgument, splitMethod)).replace(state.getEndPosition(receiver), state.getEndPosition(tree), (mutableList ? ")" : "") + ")");
        }
        if (ASTHelpers.isSubtype(receiverType, JAVA_UTIL_REGEX_PATTERN.get(state), state)) {
            return fix.prefixWith(receiver, String.format("%sSplitter.on(", mutableList ? "new ArrayList<>(" : "")).postfixWith(receiver, ")").replace(state.getEndPosition(receiver), ASTHelpers.getStartPosition(arg), String.format(".%s(", splitMethod)).replace(state.getEndPosition(arg), state.getEndPosition(tree), (mutableList ? ")" : "") + ")");
        }
        throw new AssertionError(receiver);
    }

    @Nullable
    private static TreePath findEnclosing(VisitorState state) {
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            switch (path.getLeaf().getKind()) {
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    return path;
                }
                case CLASS: {
                    return null;
                }
            }
        }
        return null;
    }
}

