/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.common.AnnotationMirrors;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;

@BugPattern(summary="Suppressing \"deprecated\" is probably a typo for \"deprecation\"", severity=BugPattern.SeverityLevel.ERROR)
public class SuppressWarningsDeprecated
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> matcher = Matchers.allOf(Matchers.isType("java.lang.SuppressWarnings"), Matchers.hasArgumentWithValue("value", Matchers.stringLiteral("deprecated")));

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (!matcher.matches(annotationTree, state)) {
            return Description.NO_MATCH;
        }
        AnnotationMirror mirror = ASTHelpers.getAnnotationMirror(annotationTree);
        List<String> values = MoreAnnotations.asStrings(AnnotationMirrors.getAnnotationValue(mirror, "value")).map(v -> v.equals("deprecated") ? "deprecation" : v).map(state::getConstantExpression).collect(Collectors.toList());
        return this.describeMatch(annotationTree, (Fix)SuggestedFixes.updateAnnotationArgumentValues(annotationTree, state, "value", values).build());
    }
}

