/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import javax.lang.model.element.Name;

@BugPattern(summary="SWIG generated code that can't call a C++ destructor will leak memory", severity=BugPattern.SeverityLevel.WARNING)
public class SwigMemoryLeak
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final Matcher<MethodTree> ENCLOSING_CLASS_HAS_FINALIZER = Matchers.enclosingClass(Matchers.hasMethod(Matchers.methodIsNamed("finalize")));

    @Override
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (tree.getValue() == null || !tree.getValue().equals("C++ destructor does not have public access")) {
            return Description.NO_MATCH;
        }
        MethodTree enclosingMethodTree = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
        Name name = enclosingMethodTree.getName();
        if (!name.contentEquals("delete")) {
            return Description.NO_MATCH;
        }
        if (ENCLOSING_CLASS_HAS_FINALIZER.matches(enclosingMethodTree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).build();
    }
}

