/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="A large number of parameters on public APIs should be avoided.", severity=BugPattern.SeverityLevel.WARNING)
public class TooManyParameters
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final int DEFAULT_LIMIT = 9;
    static final String TOO_MANY_PARAMETERS_FLAG_NAME = "TooManyParameters:ParameterLimit";
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of("java.lang.Deprecated", "java.lang.Override", "javax.inject.Inject", "com.google.inject.Inject", "com.google.inject.Provides", "dagger.Provides", new String[]{"dagger.producers.Produces", "com.google.auto.factory.AutoFactory"});
    private final int limit;

    public TooManyParameters(ErrorProneFlags flags) {
        this.limit = flags.getInteger(TOO_MANY_PARAMETERS_FLAG_NAME).orElse(9);
        Preconditions.checkArgument(this.limit > 0, "%s (%s) must be > 0", (Object)TOO_MANY_PARAMETERS_FLAG_NAME, this.limit);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        int paramCount = tree.getParameters().size();
        if (paramCount <= this.limit) {
            return Description.NO_MATCH;
        }
        if (!TooManyParameters.shouldApplyApiChecks(tree, state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("Consider using a builder pattern instead of a method with %s parameters. Data shows that defining methods with > 5 parameters often leads to bugs. See also Effective Java, Item 2.", paramCount);
        return this.buildDescription(tree).setMessage(message).build();
    }

    private static boolean shouldApplyApiChecks(MethodTree tree, VisitorState state) {
        for (String annotation : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Tree)tree, annotation, state)) continue;
            return false;
        }
        if (!ASTHelpers.getSymbol(tree).getModifiers().contains((Object)Modifier.PUBLIC)) {
            return false;
        }
        ClassTree clazz = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
        if (!ASTHelpers.getSymbol(clazz).getModifiers().contains((Object)Modifier.PUBLIC)) {
            return false;
        }
        return ASTHelpers.findSuperMethods(ASTHelpers.getSymbol(tree), state.getTypes()).isEmpty();
    }
}

