/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Static fields are implicitly transient, so the explicit modifier is unnecessary", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING)
public class TransientMisuse
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getModifiers().getFlags().containsAll(ImmutableList.of(Modifier.STATIC, Modifier.TRANSIENT))) {
            return this.describeMatch(tree, (Fix)SuggestedFixes.removeModifiers(tree, state, Modifier.TRANSIENT).orElse(SuggestedFix.emptyFix()));
        }
        return Description.NO_MATCH;
    }
}

