/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.Objects;

@BugPattern(summary="Asserting on getOrDefault is unclear; prefer containsEntry or doesNotContainKey", severity=BugPattern.SeverityLevel.WARNING)
public final class TruthGetOrDefault
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSERT_THAT = MethodMatchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat");
    private static final Matcher<ExpressionTree> GET_OR_DEFAULT_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").named("getOrDefault");
    private static final Matcher<ExpressionTree> SUBJECT_EQUALS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("isEqualTo").withParameters("java.lang.Object", new String[0]);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!SUBJECT_EQUALS_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree rec = ASTHelpers.getReceiver(tree);
        if (rec == null) {
            return Description.NO_MATCH;
        }
        if (!ASSERT_THAT.matches(rec, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = Iterables.getOnlyElement(((MethodInvocationTree)rec).getArguments());
        if (!GET_OR_DEFAULT_MATCHER.matches(arg, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree argMethodInvocationTree = (MethodInvocationTree)arg;
        ExpressionTree defaultVal = argMethodInvocationTree.getArguments().get(1);
        ExpressionTree expectedVal = Iterables.getOnlyElement(tree.getArguments());
        Match match = TruthGetOrDefault.areValuesSame(defaultVal, expectedVal, state);
        switch (match) {
            case UNKNOWN: {
                return Description.NO_MATCH;
            }
            case DIFFERENT: {
                return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(argMethodInvocationTree, state.getSourceForNode(ASTHelpers.getReceiver(argMethodInvocationTree))).replace(state.getEndPosition(rec), state.getEndPosition(tree.getMethodSelect()), ".containsEntry").replace(tree.getArguments().get(0), state.getSourceForNode(argMethodInvocationTree.getArguments().get(0)) + ", " + state.getSourceForNode(tree.getArguments().get(0))).build());
            }
            case SAME: {
                return this.describeMatch(tree, (Fix)SuggestedFix.builder().replace(arg, state.getSourceForNode(ASTHelpers.getReceiver(arg))).replace(state.getEndPosition(rec), state.getEndPosition(tree.getMethodSelect()), ".doesNotContainKey").replace(tree.getArguments().get(0), state.getSourceForNode(argMethodInvocationTree.getArguments().get(0))).build());
            }
        }
        return Description.NO_MATCH;
    }

    private static Match areValuesSame(ExpressionTree defaultVal, ExpressionTree expectedVal, VisitorState state) {
        if (ASTHelpers.sameVariable(defaultVal, expectedVal)) {
            return Match.SAME;
        }
        Object expectedConstVal = ASTHelpers.constValue(expectedVal);
        Object defaultConstVal = ASTHelpers.constValue(defaultVal);
        if (expectedConstVal == null || defaultConstVal == null) {
            return Match.UNKNOWN;
        }
        if (Objects.equals(defaultConstVal, expectedConstVal)) {
            return Match.SAME;
        }
        if (!state.getTypes().isSameType(ASTHelpers.getType(expectedVal), ASTHelpers.getType(defaultVal))) {
            return Match.UNKNOWN;
        }
        return Match.DIFFERENT;
    }

    private static enum Match {
        SAME,
        DIFFERENT,
        UNKNOWN;

    }
}

