/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.names.NamingConventions;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Name;

@BugPattern(summary="Type parameters must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s5.2.8-type-variable-names")
public class TypeParameterNaming
extends BugChecker
implements BugChecker.TypeParameterTreeMatcher {
    private static final Pattern TRAILING_DIGIT_EXTRACTOR = Pattern.compile("^(.*?)(\\d+)$");
    private static final Pattern SINGLE_PLUS_MAYBE_DIGITS = Pattern.compile("[A-Z]\\d*");

    private static String upperCamelToken(String s) {
        return Ascii.toUpperCase(s.charAt(0)) + (s.length() == 1 ? "" : s.substring(1));
    }

    @Override
    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        TypeParameterNamingClassification classification = TypeParameterNamingClassification.classify(tree.getName().toString());
        if (classification.isValidName()) {
            return Description.NO_MATCH;
        }
        Description.Builder descriptionBuilder = this.buildDescription(tree).setMessage(TypeParameterNaming.errorMessage(tree.getName(), classification));
        TreePath enclosingPath = TypeParameterNaming.enclosingMethodOrClass(state.getPath());
        if (classification != TypeParameterNamingClassification.NON_CLASS_NAME_WITH_T_SUFFIX) {
            descriptionBuilder.addFix(SuggestedFixes.renameTypeParameter(tree, state.getPath().getParentPath().getLeaf(), TypeParameterNaming.suggestedNameFollowedWithT(tree.getName().toString()), state.withPath(enclosingPath)));
        }
        return descriptionBuilder.addFix(SuggestedFixes.renameTypeParameter(tree, state.getPath().getParentPath().getLeaf(), TypeParameterNaming.suggestedSingleLetter(tree.getName().toString(), tree), state.withPath(enclosingPath))).build();
    }

    private static TreePath enclosingMethodOrClass(TreePath path) {
        for (TreePath parent = path; parent != null; parent = parent.getParentPath()) {
            if (!(parent.getLeaf() instanceof MethodTree) && !(parent.getLeaf() instanceof ClassTree)) continue;
            return parent;
        }
        return path;
    }

    private static String errorMessage(Name name, TypeParameterNamingClassification classification) {
        Preconditions.checkArgument(!classification.isValidName());
        if (classification == TypeParameterNamingClassification.NON_CLASS_NAME_WITH_T_SUFFIX) {
            return String.format("Type Parameters should be an UpperCamelCase name followed by the letter 'T'. %s ends in T, but is not a valid UpperCamelCase name", name);
        }
        return String.format("Type Parameter %s must be a single letter with an optional numeric suffix, or an UpperCamelCase name followed by the letter 'T'.", name);
    }

    private static List<Symbol.TypeVariableSymbol> typeVariablesEnclosing(Symbol sym) {
        ArrayList<Symbol.TypeVariableSymbol> typeVarScopes = new ArrayList<Symbol.TypeVariableSymbol>();
        block4: while (!sym.isStatic()) {
            sym = sym.owner;
            switch (sym.getKind()) {
                case PACKAGE: {
                    break block4;
                }
                case METHOD: 
                case CLASS: {
                    typeVarScopes.addAll(0, sym.getTypeParameters());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return typeVarScopes;
    }

    private static String suggestedSingleLetter(String id, Tree tree) {
        char firstLetter = Ascii.toUpperCase(((String)NamingConventions.splitToLowercaseTerms(id).get(0)).charAt(0));
        Symbol sym = ASTHelpers.getSymbol(tree);
        List<Symbol.TypeVariableSymbol> enclosingTypeSymbols = TypeParameterNaming.typeVariablesEnclosing(sym);
        for (Symbol.TypeVariableSymbol typeName : enclosingTypeSymbols) {
            char enclosingTypeFirstLetter = typeName.toString().charAt(0);
            if (enclosingTypeFirstLetter != firstLetter || TypeParameterNamingClassification.classify(typeName.name.toString()).isValidName()) continue;
            ImmutableList<String> typeVarsInScope = Streams.concat(enclosingTypeSymbols.stream(), sym.getTypeParameters().stream()).map(v -> v.name.toString()).collect(ImmutableList.toImmutableList());
            return TypeParameterNaming.firstLetterReplacementName(id, typeVarsInScope);
        }
        return Character.toString(firstLetter);
    }

    private static String firstLetterReplacementName(String name, List<String> superTypeVars) {
        String firstLetterOfBase = Character.toString(name.charAt(0));
        int typeVarNum = 2;
        boolean first = true;
        Matcher matcher = TRAILING_DIGIT_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1);
            typeVarNum = Integer.parseInt(matcher.group(2)) + 1;
        }
        Object replacementName = "";
        for (String superTypeVar : superTypeVars) {
            if (superTypeVar.equals(name)) {
                if (typeVarNum != 2 || !first) break;
                return firstLetterOfBase;
            }
            if (superTypeVar.charAt(0) != name.charAt(0)) continue;
            if (!first) {
                ++typeVarNum;
            } else {
                first = false;
            }
            replacementName = firstLetterOfBase + typeVarNum;
        }
        while (superTypeVars.contains(replacementName)) {
            replacementName = firstLetterOfBase + ++typeVarNum;
        }
        return replacementName;
    }

    private static String suggestedNameFollowedWithT(String identifier) {
        String token;
        Preconditions.checkArgument(!identifier.isEmpty());
        if (identifier.length() > 2 && identifier.charAt(0) == 'T' && Ascii.isUpperCase(identifier.charAt(1)) && Ascii.isLowerCase(identifier.charAt(2))) {
            ImmutableList<String> tokens = NamingConventions.splitToLowercaseTerms(identifier.substring(1));
            return Streams.concat(tokens.stream(), Stream.of("T")).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        ImmutableList<String> tokens = NamingConventions.splitToLowercaseTerms(identifier);
        if (tokens.size() == 1 && Ascii.toUpperCase(token = (String)tokens.get(0)).equals(identifier)) {
            return TypeParameterNaming.upperCamelToken(token) + "T";
        }
        if (Iterables.getLast(tokens).equals("type")) {
            return Streams.concat(tokens.subList(0, tokens.size() - 1).stream(), Stream.of("T")).map(TypeParameterNaming::upperCamelToken).collect(Collectors.joining());
        }
        return identifier + "T";
    }

    public static enum TypeParameterNamingClassification {
        LETTER_WITH_MAYBE_NUMERAL(true),
        CLASS_NAME_WITH_T(true),
        NON_CLASS_NAME_WITH_T_SUFFIX(false),
        UNCLASSIFIED(false);

        private final boolean isValidName;

        private TypeParameterNamingClassification(boolean isValidName) {
            this.isValidName = isValidName;
        }

        public static TypeParameterNamingClassification classify(String name) {
            if (SINGLE_PLUS_MAYBE_DIGITS.matcher(name).matches()) {
                return LETTER_WITH_MAYBE_NUMERAL;
            }
            if (!name.endsWith("T")) {
                return UNCLASSIFIED;
            }
            ImmutableList<String> tokens = NamingConventions.splitToLowercaseTerms(name);
            String reassembled = tokens.stream().map(x$0 -> TypeParameterNaming.upperCamelToken(x$0)).collect(Collectors.joining());
            return name.equals(reassembled) ? CLASS_NAME_WITH_T : NON_CLASS_NAME_WITH_T_SUFFIX;
        }

        public boolean isValidName() {
            return this.isValidName;
        }
    }
}

