/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;

@BugPattern(summary="Type parameter declaration overrides another type parameter already declared", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class TypeParameterShadowing
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Pattern TRAILING_DIGIT_EXTRACTOR = Pattern.compile("^(.*?)(\\d+)$");

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findDuplicatesOf(tree, tree.getTypeParameters(), state);
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getTypeParameters().isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.findDuplicatesOf(tree, tree.getTypeParameters(), state);
    }

    private Description findDuplicatesOf(Tree tree, List<? extends TypeParameterTree> typeParameters, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        List<Symbol.TypeVariableSymbol> enclosingTypeSymbols = TypeParameterShadowing.typeVariablesEnclosing(symbol);
        if (enclosingTypeSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList conflictingTypeSymbols = new ArrayList();
        typeParameters.forEach(param -> enclosingTypeSymbols.stream().filter(tvs -> tvs.name.contentEquals(param.getName())).findFirst().ifPresent(conflictingTypeSymbols::add));
        if (conflictingTypeSymbols.isEmpty()) {
            return Description.NO_MATCH;
        }
        Description.Builder descriptionBuilder = this.buildDescription(tree);
        String message = "Found aliased type parameters: " + conflictingTypeSymbols.stream().map(tvs -> tvs.name + " declared in " + tvs.owner.getSimpleName()).collect(Collectors.joining("\n"));
        descriptionBuilder.setMessage(message);
        ImmutableSet typeVarsInScope = Streams.concat(enclosingTypeSymbols.stream(), symbol.getTypeParameters().stream()).map(v -> v.name.toString()).collect(ImmutableSet.toImmutableSet());
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        conflictingTypeSymbols.stream().map(v -> SuggestedFixes.renameTypeParameter(TypeParameterShadowing.typeParameterInList(typeParameters, v), tree, TypeParameterShadowing.replacementTypeVarName(v.name, typeVarsInScope), state)).forEach(fixBuilder::merge);
        descriptionBuilder.addFix(fixBuilder.build());
        return descriptionBuilder.build();
    }

    static TypeParameterTree typeParameterInList(List<? extends TypeParameterTree> typeParameters, Symbol v) {
        return (TypeParameterTree)typeParameters.stream().filter(t -> t.getName().contentEquals(v.name)).collect(MoreCollectors.onlyElement());
    }

    static String replacementTypeVarName(Name name, Set<String> superTypeVars) {
        String replacementName;
        String baseName = name.toString();
        int typeVarNum = 2;
        Matcher matcher = TRAILING_DIGIT_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            baseName = matcher.group(1);
            typeVarNum = Integer.parseInt(matcher.group(2)) + 1;
        }
        while (superTypeVars.contains(replacementName = baseName + typeVarNum)) {
            ++typeVarNum;
        }
        return replacementName;
    }

    private static List<Symbol.TypeVariableSymbol> typeVariablesEnclosing(Symbol sym) {
        ArrayList<Symbol.TypeVariableSymbol> typeVarScopes = new ArrayList<Symbol.TypeVariableSymbol>();
        block4: while (!sym.isStatic()) {
            sym = sym.owner;
            switch (sym.getKind()) {
                case PACKAGE: {
                    break block4;
                }
                case METHOD: 
                case CLASS: {
                    typeVarScopes.addAll(sym.getTypeParameters());
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return typeVarScopes;
    }
}

