/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypesWithUndefinedEquality;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;

@BugPattern(summary="This type is not guaranteed to implement a useful #equals method.", severity=BugPattern.SeverityLevel.WARNING)
public final class UndefinedEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IS_EQUAL_TO = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").named("isEqualTo");
    private static final Matcher<MethodInvocationTree> ASSERT_THAT_EQUALS = Matchers.allOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf("isEqualTo", "isNotEqualTo"), Matchers.receiverOfInvocation(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that"))));
    private static final Supplier<Type> COM_GOOGLE_COMMON_COLLECT_MULTIMAP = VisitorState.memoize(state -> state.getTypeFromString("com.google.common.collect.Multimap"));
    private static final Supplier<Type> JAVA_LANG_CHARSEQUENCE = VisitorState.memoize(state -> state.getTypeFromString("java.lang.CharSequence"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (Matchers.staticEqualsInvocation().matches(tree, state) || Matchers.assertEqualsInvocation().matches(tree, state) || Matchers.assertNotEqualsInvocation().matches(tree, state)) {
            receiver = arguments.get(arguments.size() - 2);
            argument = Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches(tree, state)) {
            receiver = ASTHelpers.getReceiver(tree);
            argument = arguments.get(0);
        } else if (ASSERT_THAT_EQUALS.matches(tree, state)) {
            receiver = Iterables.getOnlyElement(arguments);
            argument = Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver(tree)).getArguments());
        } else {
            return Description.NO_MATCH;
        }
        return Arrays.stream(TypesWithUndefinedEquality.values()).filter(b -> b.matchesType(ASTHelpers.getType(receiver), state) || b.matchesType(ASTHelpers.getType(argument), state)).findFirst().map(b -> this.buildDescription(tree).setMessage(b.shortName() + " does not have well-defined equals behavior.").addFix(UndefinedEquals.generateFix(tree, state, receiver, argument).orElse(SuggestedFix.emptyFix())).build()).orElse(Description.NO_MATCH);
    }

    private static Optional<SuggestedFix> generateFix(MethodInvocationTree tree, VisitorState state, Tree receiver, Tree argument) {
        if (IS_EQUAL_TO.matches(tree, state)) {
            String methodText = state.getSourceForNode(tree.getMethodSelect());
            String assertThatWithArg = methodText.substring(0, methodText.lastIndexOf(46));
            BiFunction<Type, String, Optional> generateTruthFix = (type, replacementMethod) -> {
                if (type != null && ASTHelpers.isSubtype(ASTHelpers.getType(argument), type, state) && ASTHelpers.isSubtype(ASTHelpers.getType(receiver), type, state)) {
                    return Optional.of(SuggestedFix.replace(tree, String.format("%s.%s(%s)", assertThatWithArg, replacementMethod, state.getSourceForNode(receiver))));
                }
                return Optional.empty();
            };
            Type iterableType = state.getSymtab().iterableType;
            Type multimapType = COM_GOOGLE_COMMON_COLLECT_MULTIMAP.get(state);
            Optional<SuggestedFix> fix = UndefinedEquals.firstPresent(generateTruthFix.apply(iterableType, "containsExactlyElementsIn"), generateTruthFix.apply(multimapType, "containsExactlyEntriesIn"));
            if (fix.isPresent()) {
                return fix;
            }
        }
        Type charSequenceType = JAVA_LANG_CHARSEQUENCE.get(state);
        BiFunction<Tree, Tree, Optional> generateCharSequenceFix = (maybeCharSequence, maybeString) -> {
            if (charSequenceType != null && ASTHelpers.isSameType(ASTHelpers.getType(maybeCharSequence), charSequenceType, state) && ASTHelpers.isSameType(ASTHelpers.getType(maybeString), state.getSymtab().stringType, state)) {
                return Optional.of(SuggestedFix.postfixWith(maybeCharSequence, ".toString()"));
            }
            return Optional.empty();
        };
        return UndefinedEquals.firstPresent(generateCharSequenceFix.apply(receiver, argument), generateCharSequenceFix.apply(argument, receiver));
    }

    private static <T> Optional<T> firstPresent(Optional<T> ... optionals) {
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

