/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.FixedPosition;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.SourceCodeEscapers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.parser.Tokens;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="Avoid using non-ASCII Unicode characters outside of comments and literals, as they can be confusing.")
public final class UnicodeInCode
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        TreeRangeSet<Integer> violations = TreeRangeSet.create();
        String sourceCode = state.getSourceCode().toString();
        for (int i = 0; i < sourceCode.length(); ++i) {
            char c = sourceCode.charAt(i);
            if (UnicodeInCode.isAcceptableAscii(c)) continue;
            violations.add(Range.closedOpen(i, i + 1));
        }
        if (violations.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableRangeSet<Integer> permissibleUnicodeRegions = this.suppressedRegions(state).union(UnicodeInCode.commentsAndLiterals(state, sourceCode));
        for (Range range : violations.asDescendingSetOfRanges()) {
            if (permissibleUnicodeRegions.encloses(range)) continue;
            state.reportMatch(this.buildDescription(new FixedPosition(tree, (Integer)range.lowerEndpoint())).setMessage(String.format("Avoid using non-ASCII Unicode character (%s) outside of comments and literals, as they can be confusing.", SourceCodeEscapers.javaCharEscaper().escape(sourceCode.substring((Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint())))).build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isAcceptableAscii(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private static ImmutableRangeSet<Integer> commentsAndLiterals(VisitorState state, String source) {
        ImmutableList<ErrorProneToken> tokens = ErrorProneTokens.getTokens(source, state.context);
        return ImmutableRangeSet.unionOf(Streams.concat(tokens.stream().filter(t -> t.kind().equals(Tokens.TokenKind.STRINGLITERAL) || t.kind().equals(Tokens.TokenKind.CHARLITERAL)).map(t -> Range.closed(t.pos(), t.endPos())), tokens.stream().flatMap(t -> t.comments().stream()).map(c -> Range.closed(c.getSourcePos(0), c.getSourcePos(0) + c.getText().length()))).collect(ImmutableList.toImmutableList()));
    }
}

