/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@BugPattern(altNames={"RestrictInjectVisibility"}, summary="Some methods (such as those annotated with @Inject or @Provides) are only intended to be called by a framework, and so should have default visibility.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessarilyVisible
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<Modifier> VISIBILITY_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PROTECTED, (Enum[])new Modifier[]{Modifier.PUBLIC});
    private static final Supplier<ImmutableSet<Name>> FRAMEWORK_ANNOTATIONS = VisitorState.memoize(s -> Stream.of("com.google.inject.Inject", "com.google.inject.Provides", "com.google.inject.multibindings.ProvidesIntoMap", "com.google.inject.multibindings.ProvidesIntoSet", "dagger.Provides", "javax.inject.Inject").map(s::getName).collect(ImmutableSet.toImmutableSet()));
    private static final Supplier<ImmutableSet<Name>> INJECT_ANNOTATIONS = VisitorState.memoize(s -> Stream.of("com.google.inject.Inject", "javax.inject.Inject").map(s::getName).collect(ImmutableSet.toImmutableSet()));
    private static final String VISIBLE_FOR_TESTING_CAVEAT = " If this is only for testing purposes, consider annotating the element with @VisibleForTesting.";

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (ASTHelpers.annotationsAmong(symbol, (Set<? extends Name>)FRAMEWORK_ANNOTATIONS.get(state), state).isEmpty()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.findSuperMethod(symbol, state.getTypes()).isPresent()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName(tree, "VisibleForTesting")) {
            return Description.NO_MATCH;
        }
        Sets.SetView<Modifier> badModifiers = Sets.intersection(tree.getModifiers().getFlags(), VISIBILITY_MODIFIERS);
        if (badModifiers.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).addFix(SuggestedFixes.removeModifiers(tree.getModifiers(), state, badModifiers).orElse(SuggestedFix.emptyFix())).setMessage(this.message() + (ASTHelpers.annotationsAmong(symbol, (Set<? extends Name>)INJECT_ANNOTATIONS.get(state), state).isEmpty() ? "" : VISIBLE_FOR_TESTING_CAVEAT)).build();
    }
}

