/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Since Java 8, it's been unnecessary to make local variables and parameters `final` for use in lambdas or anonymous classes. Marking them as `final` is weakly discouraged, as it adds a fair amount of noise for minimal benefit.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessaryFinal
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        if (((Symbol)symbol).getKind() == ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        if (!tree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        ImmutableList<ErrorProneToken> tokens = ErrorProneTokens.getTokens(state.getSourceForNode(tree.getModifiers()), state.context);
        for (ErrorProneToken token : tokens) {
            if (token.kind() != Tokens.TokenKind.FINAL) continue;
            int startPos = ASTHelpers.getStartPosition(tree);
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(startPos + token.pos(), startPos + token.endPos(), ""));
        }
        return Description.NO_MATCH;
    }
}

