/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Converting a long or Long to an int to pass as a long parameter is usually not necessary. If this conversion is intentional, consider `Longs.constrainToRange()` instead.", severity=BugPattern.SeverityLevel.WARNING)
public class UnnecessaryLongToIntConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LONG_TO_INT_STATIC_METHODS = Matchers.anyOf(MethodMatchers.staticMethod().onClass("com.google.common.primitives.Ints").named("checkedCast"), MethodMatchers.staticMethod().onClass("java.lang.Math").named("toIntExact"));
    private static final Matcher<ExpressionTree> LONG_TO_INT_INSTANCE_METHODS = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass(Suppliers.JAVA_LANG_LONG_TYPE).named("intValue"));
    private static final Matcher<ExpressionTree> IS_LONG_TYPE = Matchers.anyOf(Matchers.isSameType(Suppliers.LONG_TYPE), Matchers.isSameType(Suppliers.JAVA_LANG_LONG_TYPE));
    private static final Matcher<ExpressionTree> LONG_TO_INT_STATIC_METHOD_ON_LONG_VALUE_MATCHER = Matchers.methodInvocation(LONG_TO_INT_STATIC_METHODS, ChildMultiMatcher.MatchType.ALL, IS_LONG_TYPE);
    private static final Matcher<ExpressionTree> LONG_TO_INT_INSTANCE_METHOD_ON_LONG_VALUE_MATCHER = Matchers.methodInvocation(LONG_TO_INT_INSTANCE_METHODS, ChildMultiMatcher.MatchType.ALL, IS_LONG_TYPE);
    private static final Matcher<TypeCastTree> LONG_TO_INT_CAST = Matchers.typeCast(Matchers.isSameType(Suppliers.INT_TYPE), Matchers.isSameType(Suppliers.LONG_TYPE));
    private static final String LONGS_CONSTRAIN_TO_RANGE_PREFIX = "Longs.constrainToRange(";
    private static final String LONGS_CONSTRAIN_TO_RANGE_SUFFIX = ", Integer.MIN_VALUE, Integer.MAX_VALUE)";
    private static final String LONGS_CONSTRAIN_TO_RANGE_IMPORT = "com.google.common.primitives.Longs";

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        for (ExpressionTree expressionTree : tree.getArguments()) {
            ASTHelpers.TargetType targetType;
            if (!ASTHelpers.getType(expressionTree).getKind().equals((Object)TypeKind.INT) || (targetType = ASTHelpers.targetType(state.withPath(new TreePath(state.getPath(), expressionTree)))) == null || !targetType.type().getKind().equals((Object)TypeKind.LONG)) continue;
            if (expressionTree instanceof TypeCastTree && LONG_TO_INT_CAST.matches((TypeCastTree)expressionTree, state)) {
                ExpressionTree castedExpression = ((TypeCastTree)expressionTree).getExpression();
                return this.buildDescription(tree).addFix(SuggestedFix.replace(expressionTree, state.getSourceForNode(castedExpression))).addFix(SuggestedFix.builder().replace(expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + state.getSourceForNode(castedExpression) + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
            }
            if (LONG_TO_INT_STATIC_METHOD_ON_LONG_VALUE_MATCHER.matches(expressionTree, state)) {
                ExpressionTree methodArgExpression = ((MethodInvocationTree)expressionTree).getArguments().get(0);
                String methodArg = state.getSourceForNode(methodArgExpression);
                return this.buildDescription(tree).addFix(SuggestedFix.replace(expressionTree, methodArg)).addFix(SuggestedFix.builder().replace(expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + methodArg + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
            }
            if (!LONG_TO_INT_INSTANCE_METHOD_ON_LONG_VALUE_MATCHER.matches(expressionTree, state)) continue;
            String receiver = state.getSourceForNode(ASTHelpers.getReceiver(expressionTree));
            return this.buildDescription(tree).addFix(SuggestedFix.replace(expressionTree, receiver)).addFix(SuggestedFix.builder().replace(expressionTree, LONGS_CONSTRAIN_TO_RANGE_PREFIX + receiver + LONGS_CONSTRAIN_TO_RANGE_SUFFIX).addImport(LONGS_CONSTRAIN_TO_RANGE_IMPORT).build()).build();
        }
        return Description.NO_MATCH;
    }
}

