/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;

@BugPattern(summary="This code can be simplified by directly using the lambda parameters instead of calling get..() on optional.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnnecessaryOptionalGet
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> OPTIONAL_FUNCTIONS_WITH_FUNCTIONAL_ARG = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.util.Optional").namedAnyOf("map", "filter", "ifPresent", "flatMap"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalLong").named("ifPresent"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalInt").named("ifPresent"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalDouble").named("ifPresent"), MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Optional").named("transform"));
    private static final Matcher<ExpressionTree> OPTIONAL_GET = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.util.Optional").namedAnyOf("get", "orElseThrow", "orElse", "orElseGet", "orElseThrow"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalLong").namedAnyOf("getAsLong", "orElse", "orElseGet", "orElseThrow"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalInt").namedAnyOf("getAsInt", "orElse", "orElseGet", "orElseThrow"), MethodMatchers.instanceMethod().onExactClass("java.util.OptionalDouble").namedAnyOf("getAsDouble", "orElse", "orElseGet", "orElseThrow"), MethodMatchers.instanceMethod().onExactClass("com.google.common.base.Optional").namedAnyOf("get", "or", "orNull"));

    @Override
    public Description matchMethodInvocation(final MethodInvocationTree tree, final VisitorState state) {
        if (!OPTIONAL_FUNCTIONS_WITH_FUNCTIONAL_ARG.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree onlyArg = Iterables.getOnlyElement(tree.getArguments());
        if (!onlyArg.getKind().equals((Object)Tree.Kind.LAMBDA_EXPRESSION)) {
            return Description.NO_MATCH;
        }
        final VariableTree arg = Iterables.getOnlyElement(((LambdaExpressionTree)onlyArg).getParameters());
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreeScanner<Void, VisitorState>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
                if (OPTIONAL_GET.matches(methodInvocationTree, visitorState) && ASTHelpers.sameVariable(ASTHelpers.getReceiver(tree), ASTHelpers.getReceiver(methodInvocationTree))) {
                    fix.replace(methodInvocationTree, state.getSourceForNode(arg));
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, visitorState);
            }
        }.scan(onlyArg, state);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

