/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@BugPattern(altNames={"unused"}, summary="This nested class is unused, and can be removed.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedNestedClass
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        PrivateNestedClassScanner privateNestedClassScanner = new PrivateNestedClassScanner(state);
        privateNestedClassScanner.scan(state.getPath(), null);
        Map<Symbol.ClassSymbol, TreePath> privateNestedClasses = privateNestedClassScanner.classes;
        ClassUsageScanner classUsageScanner = new ClassUsageScanner();
        classUsageScanner.scan(state.getPath(), null);
        privateNestedClasses.keySet().removeAll(classUsageScanner.usedClasses);
        for (TreePath path : privateNestedClasses.values()) {
            state.reportMatch(this.describeMatch(path.getLeaf(), (Fix)SuggestedFixes.replaceIncludingComments(path, "", state)));
        }
        return Description.NO_MATCH;
    }

    private static final class ClassUsageScanner
    extends TreePathScanner<Void, Void> {
        private final Set<Symbol.ClassSymbol> withinClasses = new HashSet<Symbol.ClassSymbol>();
        private final Set<Symbol.ClassSymbol> usedClasses = new HashSet<Symbol.ClassSymbol>();

        private ClassUsageScanner() {
        }

        @Override
        public Void visitClass(ClassTree classTree, Void unused) {
            Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(classTree);
            this.withinClasses.add(symbol);
            super.visitClass(classTree, null);
            this.withinClasses.remove(symbol);
            return null;
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
            this.handle(memberSelectTree);
            return (Void)super.visitMemberSelect(memberSelectTree, null);
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
            this.handle(identifierTree);
            return (Void)super.visitIdentifier(identifierTree, null);
        }

        private void handle(Tree node) {
            Symbol symbol = ASTHelpers.getSymbol(node);
            while (symbol != null) {
                if (symbol instanceof Symbol.ClassSymbol && !this.withinClasses.contains(symbol)) {
                    this.usedClasses.add((Symbol.ClassSymbol)symbol);
                }
                symbol = ASTHelpers.enclosingClass(symbol);
            }
        }
    }

    private final class PrivateNestedClassScanner
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol.ClassSymbol, TreePath> classes = new HashMap<Symbol.ClassSymbol, TreePath>();
        private final VisitorState state;

        private PrivateNestedClassScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void unused) {
            boolean isAnonymous;
            if (this.ignoreUnusedClass(classTree, this.state)) {
                return null;
            }
            Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(classTree);
            boolean bl = isAnonymous = classTree.getSimpleName().length() == 0;
            if (!isAnonymous && (ASTHelpers.canBeRemoved(symbol) || symbol.owner instanceof Symbol.MethodSymbol)) {
                this.classes.put(symbol, this.getCurrentPath());
            }
            return (Void)super.visitClass(classTree, null);
        }

        private boolean ignoreUnusedClass(ClassTree classTree, VisitorState state) {
            return UnusedNestedClass.this.isSuppressed(classTree, state) || ASTHelpers.shouldKeep(classTree);
        }
    }
}

