/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import java.util.List;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This type parameter is unused and can be removed.")
public final class UnusedTypeParameter
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableMultiset<Symbol.TypeVariableSymbol> usedIdentifiers = UnusedTypeParameter.findUsedIdentifiers(tree);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                if ((ASTHelpers.getSymbol(node).flags() & 0x10L) != 0L) {
                    this.handle(node, node.getTypeParameters());
                }
                return (Void)super.visitClass(node, null);
            }

            @Override
            public Void visitMethod(MethodTree node, Void unused) {
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(node);
                if (ASTHelpers.methodCanBeOverridden(symbol) || !ASTHelpers.findSuperMethods(symbol, state.getTypes()).isEmpty()) {
                    return null;
                }
                this.handle(node, node.getTypeParameters());
                return (Void)super.visitMethod(node, null);
            }

            private void handle(Tree tree, List<? extends TypeParameterTree> typeParameters) {
                for (TypeParameterTree typeParameterTree : typeParameters) {
                    if (usedIdentifiers.count(ASTHelpers.getSymbol(typeParameterTree)) != 1) continue;
                    state.reportMatch(UnusedTypeParameter.this.describeMatch(typeParameterTree, (Fix)UnusedTypeParameter.removeTypeParameter(tree, typeParameterTree, typeParameters, state)));
                }
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static ImmutableMultiset<Symbol.TypeVariableSymbol> findUsedIdentifiers(CompilationUnitTree tree) {
        final ImmutableMultiset.Builder identifiers = ImmutableMultiset.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(tree);
                if (symbol instanceof Symbol.TypeVariableSymbol) {
                    identifiers.add((Symbol.TypeVariableSymbol)symbol);
                }
                return (Void)super.scan(tree, unused);
            }
        }.scan((Tree)tree, null);
        return identifiers.build();
    }

    private static SuggestedFix removeTypeParameter(Tree tree, TypeParameterTree typeParameter, List<? extends TypeParameterTree> typeParameters, VisitorState state) {
        if (typeParameters.size() > 1) {
            return SuggestedFixes.removeElement(typeParameter, typeParameters, state);
        }
        ImmutableList<ErrorProneToken> tokens = ErrorProneTokens.getTokens(state.getSourceForNode(tree), ASTHelpers.getStartPosition(tree), state.context);
        int startPos = tokens.reverse().stream().filter(t -> t.pos() <= ASTHelpers.getStartPosition(typeParameter) && t.kind().equals(Tokens.TokenKind.LT)).findFirst().get().pos();
        int endPos = tokens.stream().filter(t -> t.endPos() >= state.getEndPosition((Tree)Iterables.getLast(typeParameters)) && (t.kind().equals(Tokens.TokenKind.GT) || t.kind().equals(Tokens.TokenKind.GTGT))).findFirst().get().endPos();
        return SuggestedFix.replace(startPos, endPos, "");
    }
}

