/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_UnusedVariable_UnusedSpec;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.NullType;

@BugPattern(altNames={"unused", "UnusedParameters"}, summary="Unused.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedVariable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String EXEMPT_PREFIX = "unused";
    private static final ImmutableSet<String> EXEMPT_NAMES = ImmutableSet.of("ignored");
    private static final ImmutableSet<String> EXEMPTING_VARIABLE_ANNOTATIONS = ImmutableSet.of("javax.persistence.Basic", "javax.persistence.Column", "javax.persistence.Id", "javax.persistence.Version", "javax.xml.bind.annotation.XmlElement", "org.junit.Rule", new String[]{"org.openqa.selenium.support.FindAll", "org.openqa.selenium.support.FindBy", "org.openqa.selenium.support.FindBys", "org.apache.beam.sdk.transforms.DoFn.TimerId", "org.apache.beam.sdk.transforms.DoFn.StateId"});
    private final ImmutableSet<String> methodAnnotationsExemptingParameters;
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private static final ImmutableSet<String> EXEMPTING_FIELD_SUPER_TYPES = ImmutableSet.of("org.junit.rules.TestRule");
    private static final ImmutableSet<String> SPECIAL_FIELDS = ImmutableSet.of("serialVersionUID", "TAG");
    private final boolean reportInjectedFields;
    private static final ImmutableSet<Tree.Kind> TOP_LEVEL_EXPRESSIONS = ImmutableSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.METHOD_INVOCATION, new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    private static final Supplier<Type> PARCELABLE_CREATOR = VisitorState.memoize(state -> state.getTypeFromString("android.os.Parcelable.Creator"));

    public UnusedVariable(ErrorProneFlags flags) {
        ImmutableCollection.Builder methodAnnotationsExemptingParameters = ImmutableSet.builder().add("org.robolectric.annotation.Implementation");
        flags.getList("Unused:methodAnnotationsExemptingParameters").ifPresent(((ImmutableSet.Builder)methodAnnotationsExemptingParameters)::addAll);
        this.methodAnnotationsExemptingParameters = ((ImmutableSet.Builder)methodAnnotationsExemptingParameters).build();
        this.reportInjectedFields = flags.getBoolean("Unused:ReportInjectedFields").orElse(false);
    }

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (UnusedVariable.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        VariableFinder variableFinder = new VariableFinder(state);
        variableFinder.scan(state.getPath(), null);
        Map<Symbol, TreePath> unusedElements = variableFinder.unusedElements;
        Set<Symbol> onlyCheckForReassignments = variableFinder.onlyCheckForReassignments;
        ListMultimap<Symbol, TreePath> usageSites = variableFinder.usageSites;
        FilterUsedVariables filterUsedVariables = new FilterUsedVariables(unusedElements, usageSites);
        filterUsedVariables.scan(state.getPath(), null);
        Set<Symbol> isEverUsed = filterUsedVariables.isEverUsed;
        List<UnusedSpec> unusedSpecs = filterUsedVariables.unusedSpecs;
        for (Map.Entry<Symbol, TreePath> entry : unusedElements.entrySet()) {
            unusedSpecs.add(UnusedSpec.of(entry.getKey(), entry.getValue(), usageSites.get((Object)entry.getKey()), null));
        }
        ImmutableListMultimap unusedSpecsBySymbol = Multimaps.index(unusedSpecs, UnusedSpec::symbol);
        for (Map.Entry entry : ((ImmutableMap)unusedSpecsBySymbol.asMap()).entrySet()) {
            Symbol unusedSymbol = (Symbol)entry.getKey();
            Collection specs = (Collection)entry.getValue();
            ImmutableList<TreePath> allUsageSites = specs.stream().flatMap(u -> u.usageSites().stream()).collect(ImmutableList.toImmutableList());
            if (!unusedElements.containsKey(unusedSymbol)) {
                isEverUsed.add(unusedSymbol);
            }
            SuggestedFix makeFirstAssignmentDeclaration = UnusedVariable.makeAssignmentDeclaration(unusedSymbol, specs, allUsageSites, state);
            if (onlyCheckForReassignments.contains(unusedSymbol) && specs.size() <= 1) continue;
            Tree unused = ((UnusedSpec)specs.iterator().next()).assignmentPath().getLeaf();
            Symbol.VarSymbol symbol = (Symbol.VarSymbol)unusedSymbol;
            ImmutableList<SuggestedFix> fixes = symbol.getKind() == ElementKind.PARAMETER && !onlyCheckForReassignments.contains(unusedSymbol) && !isEverUsed.contains(unusedSymbol) ? UnusedVariable.buildUnusedParameterFixes(symbol, allUsageSites, state) : UnusedVariable.buildUnusedVarFixes(symbol, allUsageSites, state);
            state.reportMatch(this.buildDescription(unused).setMessage(String.format("%s %s '%s' is never read.", isEverUsed.contains(symbol) ? "This assignment to the" : "The", UnusedVariable.describeVariable(symbol), symbol.name)).addAllFixes(fixes.stream().map(f -> SuggestedFix.builder().merge(makeFirstAssignmentDeclaration).merge((SuggestedFix)f).build()).collect(ImmutableList.toImmutableList())).build());
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix makeAssignmentDeclaration(Symbol unusedSymbol, Collection<UnusedSpec> specs, ImmutableList<TreePath> allUsageSites, VisitorState state) {
        if (unusedSymbol.getKind() != ElementKind.LOCAL_VARIABLE) {
            return SuggestedFix.emptyFix();
        }
        Optional<VariableTree> removedVariableTree = allUsageSites.stream().filter(tp -> tp.getLeaf() instanceof VariableTree).findFirst().map(tp -> (VariableTree)tp.getLeaf());
        Optional<AssignmentTree> reassignment = specs.stream().map(UnusedSpec::terminatingAssignment).flatMap(Streams::stream).filter(a -> allUsageSites.stream().noneMatch(tp -> tp.getLeaf() instanceof ExpressionStatementTree && ((ExpressionStatementTree)tp.getLeaf()).getExpression().equals(a))).findFirst();
        if (removedVariableTree.isPresent() && reassignment.isPresent()) {
            return SuggestedFix.prefixWith(reassignment.get(), state.getSourceForNode(removedVariableTree.get().getType()) + " ");
        }
        return SuggestedFix.emptyFix();
    }

    private static String describeVariable(Symbol.VarSymbol symbol) {
        switch (symbol.getKind()) {
            case FIELD: {
                return "field";
            }
            case LOCAL_VARIABLE: {
                return "local variable";
            }
            case PARAMETER: {
                return "parameter";
            }
        }
        return "variable";
    }

    private static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private static boolean needsBlock(TreePath path) {
        Tree leaf = path.getLeaf();
        class Visitor
        extends SimpleTreeVisitor<Boolean, Void> {
            final /* synthetic */ Tree val$leaf;

            Visitor(Tree tree) {
                this.val$leaf = tree;
            }

            @Override
            public Boolean visitIf(IfTree tree, Void unused) {
                return tree.getThenStatement() == this.val$leaf || tree.getElseStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitDoWhileLoop(DoWhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitWhileLoop(WhileLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitForLoop(ForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }

            @Override
            public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void unused) {
                return tree.getStatement() == this.val$leaf;
            }
        }
        return MoreObjects.firstNonNull(path.getParentPath().getLeaf().accept(new Visitor(leaf), null), false);
    }

    private static ImmutableList<SuggestedFix> buildUnusedVarFixes(Symbol varSymbol, List<TreePath> usagePaths, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName(varSymbol, "Inject")) {
            return ImmutableList.of();
        }
        ElementKind varKind = varSymbol.getKind();
        boolean encounteredSideEffects = false;
        SuggestedFix.Builder keepSideEffectsFix = SuggestedFix.builder().setShortDescription("remove unused variable");
        SuggestedFix.Builder removeSideEffectsFix = SuggestedFix.builder().setShortDescription("remove unused variable and any side effects");
        for (TreePath usagePath : usagePaths) {
            StatementTree statement = (StatementTree)usagePath.getLeaf();
            if (statement.getKind() == Tree.Kind.VARIABLE) {
                if (ASTHelpers.getSymbol(statement).getKind() == ElementKind.PARAMETER) continue;
                VariableTree variableTree = (VariableTree)statement;
                ExpressionTree initializer = variableTree.getInitializer();
                if (SideEffectAnalysis.hasSideEffect(initializer) && TOP_LEVEL_EXPRESSIONS.contains((Object)initializer.getKind())) {
                    encounteredSideEffects = true;
                    if (varKind == ElementKind.FIELD) {
                        String newContent = String.format("%s{ %s; }", varSymbol.isStatic() ? "static " : "", state.getSourceForNode(initializer));
                        keepSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments(usagePath, newContent, state));
                        removeSideEffectsFix.replace(statement, "");
                        continue;
                    }
                    keepSideEffectsFix.replace(statement, String.format("%s;", state.getSourceForNode(initializer)));
                    removeSideEffectsFix.replace(statement, "");
                    continue;
                }
                if (UnusedVariable.isEnhancedForLoopVar(usagePath)) {
                    String modifiers = Strings.nullToEmpty(variableTree.getModifiers() == null ? null : state.getSourceForNode(variableTree.getModifiers()));
                    String newContent = String.format("%s%s unused", modifiers.isEmpty() ? "" : modifiers + " ", state.getSourceForNode(variableTree.getType()));
                    keepSideEffectsFix.replace(variableTree, newContent);
                    removeSideEffectsFix.replace(variableTree, newContent);
                    continue;
                }
                String replacement = UnusedVariable.needsBlock(usagePath) ? "{}" : "";
                keepSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments(usagePath, replacement, state));
                removeSideEffectsFix.merge(SuggestedFixes.replaceIncludingComments(usagePath, replacement, state));
                continue;
            }
            if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                JCTree tree = (JCTree)((Object)((ExpressionStatementTree)statement).getExpression());
                if (tree instanceof CompoundAssignmentTree) {
                    if (SideEffectAnalysis.hasSideEffect(((CompoundAssignmentTree)((Object)tree)).getExpression())) {
                        SuggestedFix replacement = SuggestedFix.replace(tree.getStartPosition(), ((JCTree.JCAssignOp)tree).getExpression().getStartPosition(), "");
                        keepSideEffectsFix.merge(replacement);
                        removeSideEffectsFix.merge(replacement);
                        continue;
                    }
                } else if (tree instanceof AssignmentTree && SideEffectAnalysis.hasSideEffect(((AssignmentTree)((Object)tree)).getExpression())) {
                    encounteredSideEffects = true;
                    keepSideEffectsFix.replace(tree.getStartPosition(), ((JCTree.JCAssign)tree).getExpression().getStartPosition(), "");
                    removeSideEffectsFix.replace(statement, "");
                    continue;
                }
            }
            String replacement = UnusedVariable.needsBlock(usagePath) ? "{}" : "";
            keepSideEffectsFix.replace(statement, replacement);
            removeSideEffectsFix.replace(statement, replacement);
        }
        return encounteredSideEffects ? ImmutableList.of(removeSideEffectsFix.build(), keepSideEffectsFix.build()) : ImmutableList.of(keepSideEffectsFix.build());
    }

    private static ImmutableList<SuggestedFix> buildUnusedParameterFixes(Symbol varSymbol, List<TreePath> usagePaths, final VisitorState state) {
        final Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)varSymbol.owner;
        final int index = methodSymbol.params.indexOf(varSymbol);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        for (TreePath path : usagePaths) {
            fix.delete(path.getLeaf());
        }
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (ASTHelpers.getSymbol(tree).equals(methodSymbol)) {
                    this.removeByIndex(tree.getArguments());
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (ASTHelpers.getSymbol(tree).equals(methodSymbol)) {
                    this.removeByIndex(tree.getParameters());
                }
                return (Void)super.visitMethod(tree, null);
            }

            private void removeByIndex(List<? extends Tree> trees) {
                int endPos;
                int startPos;
                if (index >= trees.size()) {
                    return;
                }
                if (trees.size() == 1) {
                    Tree tree = Iterables.getOnlyElement(trees);
                    if (ASTHelpers.getStartPosition(tree) == -1 || state.getEndPosition(tree) == -1) {
                        return;
                    }
                    fix.delete(tree);
                    return;
                }
                if (index >= 1) {
                    startPos = state.getEndPosition(trees.get(index - 1));
                    endPos = state.getEndPosition(trees.get(index));
                } else {
                    startPos = ASTHelpers.getStartPosition(trees.get(index));
                    endPos = ASTHelpers.getStartPosition(trees.get(index + 1));
                }
                if (index == methodSymbol.params().size() - 1 && methodSymbol.isVarArgs()) {
                    endPos = state.getEndPosition(Iterables.getLast(trees));
                }
                if (startPos == -1 || endPos == -1) {
                    return;
                }
                fix.replace(startPos, endPos, "");
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return ImmutableList.of(fix.build());
    }

    private static boolean isEnhancedForLoopVar(TreePath variablePath) {
        Tree tree = variablePath.getLeaf();
        Tree parent = variablePath.getParentPath().getLeaf();
        return parent instanceof EnhancedForLoopTree && ((EnhancedForLoopTree)parent).getVariable() == tree;
    }

    private static boolean exemptedByAnnotation(List<? extends AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            Type annotationType = ASTHelpers.getType(annotationTree);
            if (annotationType == null || !EXEMPTING_VARIABLE_ANNOTATIONS.contains((tsym = annotationType.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(javax.lang.model.element.Name name) {
        String nameString = name.toString();
        return Ascii.toLowerCase(nameString).startsWith(EXEMPT_PREFIX) || EXEMPT_NAMES.contains(nameString);
    }

    @AutoValue
    static abstract class UnusedSpec {
        UnusedSpec() {
        }

        abstract Symbol symbol();

        abstract TreePath assignmentPath();

        abstract ImmutableList<TreePath> usageSites();

        abstract Optional<AssignmentTree> terminatingAssignment();

        private static UnusedSpec of(Symbol symbol, TreePath assignmentPath, Iterable<TreePath> treePaths, @Nullable AssignmentTree assignmentTree) {
            return new AutoValue_UnusedVariable_UnusedSpec(symbol, assignmentPath, ImmutableList.copyOf(treePaths), Optional.ofNullable(assignmentTree));
        }
    }

    private static final class FilterUsedVariables
    extends TreePathScanner<Void, Void> {
        private boolean leftHandSideAssignment = false;
        private int inArrayAccess = 0;
        private boolean inReturnStatement = false;
        private int inMethodCall = 0;
        private final Map<Symbol, TreePath> assignmentSite = new HashMap<Symbol, TreePath>();
        private TreePath currentExpressionStatement = null;
        private final Map<Symbol, TreePath> unusedElements;
        private final ListMultimap<Symbol, TreePath> usageSites;
        private final Set<Symbol> isEverUsed = new HashSet<Symbol>();
        private final List<UnusedSpec> unusedSpecs = new ArrayList<UnusedSpec>();
        private final ImmutableMap<Symbol, TreePath> declarationSites;

        private FilterUsedVariables(Map<Symbol, TreePath> unusedElements, ListMultimap<Symbol, TreePath> usageSites) {
            this.unusedElements = unusedElements;
            this.usageSites = usageSites;
            this.declarationSites = ImmutableMap.copyOf(unusedElements);
        }

        private boolean isInExpressionStatementTree() {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            return parent != null && parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        }

        private boolean isUsed(@Nullable Symbol symbol) {
            return symbol != null && (!this.leftHandSideAssignment || this.inReturnStatement || this.inArrayAccess > 0 || this.inMethodCall > 0) && this.unusedElements.containsKey(symbol);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
            if (this.hasBeenAssigned(tree, symbol)) {
                this.assignmentSite.put(symbol, this.getCurrentPath());
            }
            return (Void)super.visitVariable(tree, null);
        }

        private boolean hasBeenAssigned(VariableTree tree, Symbol.VarSymbol symbol) {
            if (symbol == null) {
                return false;
            }
            if (symbol.getKind() == ElementKind.PARAMETER) {
                return true;
            }
            if (this.getCurrentPath().getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return true;
            }
            return this.unusedElements.containsKey(symbol) && tree.getInitializer() != null;
        }

        @Override
        public Void visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
            this.currentExpressionStatement = this.getCurrentPath();
            super.visitExpressionStatement(tree, null);
            this.currentExpressionStatement = null;
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree tree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol(tree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            }
            if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put(symbol, this.currentExpressionStatement);
            }
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, Void unused) {
            this.scan(tree.getExpression(), null);
            if (this.isInExpressionStatementTree()) {
                this.handleReassignment(tree);
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitAssignment(tree, null);
            }
            return null;
        }

        private void handleReassignment(AssignmentTree tree) {
            Tree parent = this.getCurrentPath().getParentPath().getLeaf();
            if (!(parent instanceof StatementTree)) {
                return;
            }
            if (tree.getVariable().getKind() != Tree.Kind.IDENTIFIER) {
                return;
            }
            if (ASTHelpers.findEnclosingNode(this.getCurrentPath(), ForLoopTree.class) != null) {
                return;
            }
            Symbol symbol = ASTHelpers.getSymbol(tree.getVariable());
            if (!(this.assignmentSite.containsKey(symbol) && symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.PARAMETER)) {
                return;
            }
            if (ASTHelpers.getType(tree.getExpression()) instanceof NullType) {
                return;
            }
            TreePath lastAssignmentSite = this.assignmentSite.get(symbol);
            if (lastAssignmentSite == null) {
                return;
            }
            TreePath declarationSite = this.declarationSites.get(symbol);
            if (declarationSite == null) {
                return;
            }
            if (FilterUsedVariables.scopeDepth(declarationSite) != Iterables.size(this.getCurrentPath().getParentPath())) {
                return;
            }
            if (this.unusedElements.containsKey(symbol)) {
                this.unusedSpecs.add(UnusedSpec.of(symbol, lastAssignmentSite, this.usageSites.get((Object)symbol), tree));
            } else {
                this.isEverUsed.add(symbol);
            }
            this.unusedElements.put(symbol, this.getCurrentPath());
            this.usageSites.removeAll(symbol);
            this.usageSites.put(symbol, this.getCurrentPath().getParentPath());
            this.assignmentSite.put(symbol, this.getCurrentPath().getParentPath());
        }

        private static int scopeDepth(TreePath assignmentSite) {
            Symbol.VarSymbol symbol;
            if (assignmentSite.getParentPath().getLeaf() instanceof EnhancedForLoopTree) {
                return Iterables.size(assignmentSite) + 1;
            }
            if (assignmentSite.getLeaf() instanceof VariableTree && (symbol = ASTHelpers.getSymbol((VariableTree)assignmentSite.getLeaf())).getKind() == ElementKind.PARAMETER) {
                return Iterables.size(assignmentSite) + 1;
            }
            return Iterables.size(assignmentSite);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol(memberSelectTree);
            if (this.isUsed(symbol)) {
                this.unusedElements.remove(symbol);
            } else if (this.currentExpressionStatement != null && this.unusedElements.containsKey(symbol)) {
                this.usageSites.put(symbol, this.currentExpressionStatement);
            }
            boolean wasLeftHandAssignment = this.leftHandSideAssignment;
            this.leftHandSideAssignment = false;
            super.visitMemberSelect(memberSelectTree, null);
            this.leftHandSideAssignment = wasLeftHandAssignment;
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
            super.visitMemberReference(tree, null);
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
            symbol.getParameters().forEach(this.unusedElements::remove);
            return null;
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            if (this.isInExpressionStatementTree()) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getVariable(), null);
                this.leftHandSideAssignment = false;
                this.scan(tree.getExpression(), null);
            } else {
                super.visitCompoundAssignment(tree, null);
            }
            return null;
        }

        @Override
        public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
            ++this.inArrayAccess;
            super.visitArrayAccess(node, null);
            --this.inArrayAccess;
            return null;
        }

        @Override
        public Void visitReturn(ReturnTree node, Void unused) {
            this.inReturnStatement = true;
            this.scan(node.getExpression(), null);
            this.inReturnStatement = false;
            return null;
        }

        @Override
        public Void visitUnary(UnaryTree tree, Void unused) {
            if (this.isInExpressionStatementTree() && (tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT || tree.getKind() == Tree.Kind.PREFIX_DECREMENT || tree.getKind() == Tree.Kind.PREFIX_INCREMENT)) {
                this.leftHandSideAssignment = true;
                this.scan(tree.getExpression(), null);
                this.leftHandSideAssignment = false;
            } else {
                super.visitUnary(tree, null);
            }
            return null;
        }

        @Override
        public Void visitErroneous(ErroneousTree tree, Void unused) {
            return (Void)this.scan(tree.getErrorTrees(), null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            ++this.inMethodCall;
            super.visitMethodInvocation(tree, null);
            --this.inMethodCall;
            return null;
        }
    }

    private class VariableFinder
    extends TreePathScanner<Void, Void> {
        private final Map<Symbol, TreePath> unusedElements = new HashMap<Symbol, TreePath>();
        private final Set<Symbol> onlyCheckForReassignments = new HashSet<Symbol>();
        private final ListMultimap<Symbol, TreePath> usageSites = ArrayListMultimap.create();
        private final VisitorState state;
        private static final long RECORD_FLAG = 0x2000000000000000L;

        private VariableFinder(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            if (UnusedVariable.exemptedByName(variableTree.getName())) {
                return null;
            }
            if (UnusedVariable.this.isSuppressed(variableTree, this.state)) {
                return null;
            }
            Symbol.VarSymbol symbol = ASTHelpers.getSymbol(variableTree);
            if (symbol.getKind() == ElementKind.FIELD && ((Name)symbol.getSimpleName()).contentEquals("CREATOR") && ASTHelpers.isSubtype(symbol.type, PARCELABLE_CREATOR.get(this.state), this.state)) {
                return null;
            }
            if (symbol.getKind() == ElementKind.FIELD && this.exemptedFieldBySuperType(ASTHelpers.getType(variableTree), this.state)) {
                return null;
            }
            super.visitVariable(variableTree, null);
            if (UnusedVariable.exemptedByAnnotation(variableTree.getModifiers().getAnnotations()) || ASTHelpers.shouldKeep(variableTree)) {
                return null;
            }
            switch (symbol.getKind()) {
                case FIELD: {
                    if (!this.isFieldEligibleForChecking(variableTree, symbol)) break;
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put(symbol, this.getCurrentPath());
                    break;
                }
                case LOCAL_VARIABLE: {
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    this.usageSites.put(symbol, this.getCurrentPath());
                    break;
                }
                case PARAMETER: {
                    if (variableTree.getName().contentEquals("this")) {
                        return null;
                    }
                    this.unusedElements.put(symbol, this.getCurrentPath());
                    if (this.isParameterSubjectToAnalysis(symbol)) break;
                    this.onlyCheckForReassignments.add(symbol);
                    break;
                }
            }
            return null;
        }

        private boolean exemptedFieldBySuperType(Type type, VisitorState state) {
            return EXEMPTING_FIELD_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype(type, state.getTypeFromString((String)t), state));
        }

        private boolean isFieldEligibleForChecking(VariableTree variableTree, Symbol.VarSymbol symbol) {
            if (UnusedVariable.this.reportInjectedFields && variableTree.getModifiers().getFlags().isEmpty() && ASTHelpers.hasDirectAnnotationWithSimpleName(variableTree, "Inject")) {
                return true;
            }
            if ((symbol.flags() & 0x2000000000000000L) == 0x2000000000000000L) {
                return false;
            }
            return ASTHelpers.canBeRemoved(symbol) && !SPECIAL_FIELDS.contains(((Name)symbol.getSimpleName()).toString());
        }

        private boolean isParameterSubjectToAnalysis(Symbol sym) {
            Preconditions.checkArgument(sym.getKind() == ElementKind.PARAMETER);
            Symbol enclosingMethod = sym.owner;
            for (String annotationName : UnusedVariable.this.methodAnnotationsExemptingParameters) {
                if (!ASTHelpers.hasAnnotation(enclosingMethod, annotationName, this.state)) continue;
                return false;
            }
            return enclosingMethod.getModifiers().contains((Object)Modifier.PRIVATE);
        }

        @Override
        public Void visitTry(TryTree node, Void unused) {
            this.scan(node.getBlock(), null);
            this.scan(node.getCatches(), null);
            this.scan(node.getFinallyBlock(), null);
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void unused) {
            if (UnusedVariable.this.isSuppressed(tree, this.state)) {
                return null;
            }
            if (EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype(ASTHelpers.getType(tree), Suppliers.typeFromString(t).get(this.state), this.state))) {
                return null;
            }
            return (Void)super.visitClass(tree, null);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
            return (Void)this.scan(node.getBody(), null);
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            if (Matchers.SERIALIZATION_METHODS.matches(tree, this.state)) {
                return (Void)this.scan(tree.getBody(), null);
            }
            return UnusedVariable.this.isSuppressed(tree, this.state) ? null : (Void)super.visitMethod(tree, unused);
        }
    }
}

