/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Name;

@BugPattern(summary="variableName and type with the same name would refer to the static field instead of the class", severity=BugPattern.SeverityLevel.WARNING)
public class VariableNameSameAsType
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    @Override
    public Description matchVariable(VariableTree varTree, VisitorState state) {
        Name varName = varTree.getName();
        Matcher<VariableTree> nameSameAsType = Matchers.variableType((typeTree, s) -> {
            Symbol typeSymbol = ASTHelpers.getSymbol(typeTree);
            if (typeSymbol != null) {
                return typeSymbol.getSimpleName().contentEquals(varName);
            }
            return false;
        });
        if (!nameSameAsType.matches(varTree, state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("Variable named %s has the type %s. Calling methods using \"%s.something\" are difficult to distinguish between static and instance methods.", varName, SuggestedFixes.prettyType(ASTHelpers.getType(varTree), null), varName);
        return this.buildDescription(varTree).setMessage(message).build();
    }
}

