/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="Consider using `var` here to avoid boilerplate.")
public final class Varifier
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> BUILD_METHOD = MethodMatchers.instanceMethod().anyClass().withNameMatching(Pattern.compile("build.*"));
    private static final Matcher<ExpressionTree> BUILDER_FACTORY = Matchers.anyOf(MethodMatchers.staticMethod().anyClass().withNameMatching(Pattern.compile("(builder|newBuilder).*")), MethodMatchers.constructor().forClass((type, state) -> ((Name)type.tsym.getSimpleName()).toString().startsWith("Builder")));
    private static final Matcher<ExpressionTree> FACTORY_METHOD = Matchers.allOf(MethodMatchers.staticMethod().anyClass().withNameMatching(Pattern.compile("(new|create|of).*")), (t, s) -> {
        Symbol symbol = ASTHelpers.getSymbol(t);
        return symbol instanceof Symbol.MethodSymbol && ASTHelpers.isSameType(((Symbol.MethodSymbol)symbol).getReturnType(), symbol.owner.type, s);
    });

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        ExpressionTree initializer = tree.getInitializer();
        if (!symbol.getKind().equals((Object)ElementKind.LOCAL_VARIABLE) || !ASTHelpers.isConsideredFinal(symbol) || initializer == null || ASTHelpers.hasNoExplicitType(tree, state)) {
            return Description.NO_MATCH;
        }
        if (initializer instanceof TypeCastTree && ASTHelpers.isSameType(ASTHelpers.getType(((TypeCastTree)initializer).getType()), ASTHelpers.getType(tree.getType()), state)) {
            return this.fix(tree);
        }
        if (initializer instanceof NewClassTree && ASTHelpers.isSameType(ASTHelpers.getType(((NewClassTree)initializer).getIdentifier()), ASTHelpers.getType(tree.getType()), state)) {
            ExpressionTree identifier = ((NewClassTree)initializer).getIdentifier();
            if (identifier instanceof ParameterizedTypeTree && ((ParameterizedTypeTree)((Object)identifier)).getTypeArguments().isEmpty()) {
                return Description.NO_MATCH;
            }
            return this.fix(tree);
        }
        if (BUILD_METHOD.matches(initializer, state) && ASTHelpers.streamReceivers(initializer).anyMatch(t -> BUILDER_FACTORY.matches((ExpressionTree)t, state))) {
            return this.fix(tree);
        }
        if (FACTORY_METHOD.matches(initializer, state)) {
            return this.fix(tree);
        }
        return Description.NO_MATCH;
    }

    private Description fix(VariableTree tree) {
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree.getType(), "var"));
    }
}

