/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Strings;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="The `^` operator is binary XOR, not a power operator.", severity=BugPattern.SeverityLevel.ERROR)
public class XorPower
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!tree.getKind().equals((Object)Tree.Kind.XOR)) {
            return Description.NO_MATCH;
        }
        Integer lhs = ASTHelpers.constValue(tree.getLeftOperand(), Integer.class);
        if (lhs == null) {
            return Description.NO_MATCH;
        }
        switch (lhs) {
            case 2: 
            case 10: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        Integer rhs = ASTHelpers.constValue(tree.getRightOperand(), Integer.class);
        if (rhs == null) {
            return Description.NO_MATCH;
        }
        if (state.getSourceForNode(tree.getRightOperand()).startsWith("0")) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree).setMessage(String.format("The ^ operator is binary XOR, not a power operator, so '%s' will always evaluate to %d.", state.getSourceForNode(tree), lhs ^ rhs));
        switch (lhs) {
            case 2: {
                if (rhs > 31) break;
                description.addFix(SuggestedFix.replace(tree, String.format("1 << %d", rhs)));
                break;
            }
            case 10: {
                if (rhs > 9) break;
                description.addFix(SuggestedFix.replace(tree, "1" + Strings.repeat("0", rhs)));
                break;
            }
            default: {
                throw new AssertionError(lhs);
            }
        }
        return description.build();
    }
}

