/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;

@BugPattern(summary="Object serialized in Bundle may have been flattened to base type.", severity=BugPattern.SeverityLevel.ERROR)
public class BundleDeserializationCast
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final Matcher<TypeCastTree> BUNDLE_DESERIALIZATION_CAST_EXPRESSION = Matchers.typeCast(Matchers.anything(), MethodMatchers.instanceMethod().onExactClass("android.os.Bundle").named("getSerializable"));

    @Override
    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (!BUNDLE_DESERIALIZATION_CAST_EXPRESSION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Tree targetType = tree.getType();
        if (Matchers.isPrimitiveType().matches(targetType, state)) {
            return Description.NO_MATCH;
        }
        if (Matchers.isSameType("java.lang.String").matches(targetType, state)) {
            return Description.NO_MATCH;
        }
        if (Matchers.isSubtypeOf("java.util.Map").matches(targetType, state)) {
            return Matchers.anyOf(Matchers.isSameType("java.util.Map"), Matchers.isSameType("java.util.HashMap")).matches(targetType, state) ? Description.NO_MATCH : this.getDescriptionForType(tree, "Map");
        }
        if (Matchers.isSubtypeOf("android.os.Parcelable").matches(targetType, state)) {
            return Description.NO_MATCH;
        }
        if (Matchers.isSubtypeOf("java.lang.CharSequence").matches(targetType, state)) {
            return Matchers.isSameType("java.lang.CharSequence").matches(targetType, state) ? Description.NO_MATCH : this.getDescriptionForType(tree, "CharSequence");
        }
        if (Matchers.isSubtypeOf("java.util.List").matches(targetType, state)) {
            return Matchers.anyOf(Matchers.isSameType("java.util.List"), Matchers.isSameType("java.util.ArrayList")).matches(targetType, state) ? Description.NO_MATCH : this.getDescriptionForType(tree, "List");
        }
        if (Matchers.isSubtypeOf("android.util.SparseArray").matches(targetType, state)) {
            return Matchers.isSameType("android.util.SparseArray").matches(targetType, state) ? Description.NO_MATCH : this.getDescriptionForType(tree, "SparseArray");
        }
        if (Matchers.isArrayType().matches(targetType, state)) {
            Type componentType = ((Type.ArrayType)ASTHelpers.getType(targetType)).getComponentType();
            Types types = state.getTypes();
            Type charSequenceType = Suppliers.typeFromString("java.lang.CharSequence").get(state);
            Type stringType = Suppliers.typeFromString("java.lang.String").get(state);
            if (types.isSubtype(componentType, charSequenceType) && !types.isSameType(componentType, charSequenceType) && !types.isSameType(componentType, stringType)) {
                return this.getDescriptionForType(tree, "CharSequence[]");
            }
        }
        return Description.NO_MATCH;
    }

    private Description getDescriptionForType(TypeCastTree tree, String baseType) {
        String targetType = ASTHelpers.getType(tree.getType()).toString();
        return this.buildDescription(tree).setMessage(String.format("When serialized in Bundle, %s may be transformed into an arbitrary subclass of %s. Please cast to %s.", targetType, baseType, baseType)).build();
    }
}

