/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import java.util.Map;

@BugPattern(altNames={"SdCardPath"}, summary="Hardcoded reference to /sdcard", severity=BugPattern.SeverityLevel.WARNING)
public class HardCodedSdCardPath
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    static final String SDCARD = "Environment.getExternalStorageDirectory().getPath()";
    static final String DATA = "Context.getFilesDir().getPath()";
    static final ImmutableMap<String, String> PATH_TABLE = new ImmutableMap.Builder<String, String>().put("/sdcard", "Environment.getExternalStorageDirectory().getPath()").put("/mnt/sdcard", "Environment.getExternalStorageDirectory().getPath()").put("/system/media/sdcard", "Environment.getExternalStorageDirectory().getPath()").put("file://sdcard", "Environment.getExternalStorageDirectory().getPath()").put("file:///sdcard", "Environment.getExternalStorageDirectory().getPath()").put("/data/data", "Context.getFilesDir().getPath()").put("/data/user", "Context.getFilesDir().getPath()").buildOrThrow();

    @Override
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (tree.getKind() != Tree.Kind.STRING_LITERAL) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isJUnitTestCode(state)) {
            return Description.NO_MATCH;
        }
        String literal = (String)tree.getValue();
        if (literal == null) {
            return Description.NO_MATCH;
        }
        for (Map.Entry entry : PATH_TABLE.entrySet()) {
            String hardCodedPath = (String)entry.getKey();
            if (!literal.startsWith(hardCodedPath)) continue;
            String correctPath = (String)entry.getValue();
            String remainderPath = literal.substring(hardCodedPath.length());
            SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
            if (remainderPath.isEmpty()) {
                suggestedFix.replace(tree, correctPath);
            } else {
                suggestedFix.replace(tree, correctPath + " + \"" + remainderPath + "\"");
            }
            if (correctPath.equals(SDCARD)) {
                suggestedFix.addImport("android.os.Environment");
            } else {
                suggestedFix.addImport("android.content.Context");
            }
            return this.describeMatch(tree, (Fix)suggestedFix.build());
        }
        return Description.NO_MATCH;
    }
}

