/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Certain resources in `android.R.string` have names that do not match their content", severity=BugPattern.SeverityLevel.ERROR)
public class MislabeledAndroidString
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final String R_STRING_CLASSNAME = "android.R.string";
    @VisibleForTesting
    static final ImmutableMap<String, String> MISLEADING = ImmutableMap.of("yes", "ok", "no", "cancel");
    @VisibleForTesting
    static final ImmutableMap<String, String> ASSUMED_MEANINGS = ImmutableMap.of("yes", "Yes", "no", "No", "ok", "OK", "cancel", "Cancel");

    @Override
    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol(tree);
        if (symbol == null || symbol.owner == null || symbol.getKind() != ElementKind.FIELD || !symbol.isStatic() || !R_STRING_CLASSNAME.contentEquals(symbol.owner.getQualifiedName())) {
            return Description.NO_MATCH;
        }
        String misleading = symbol.getSimpleName().toString();
        String preferred = MISLEADING.get(misleading);
        if (preferred == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s.%s is not \"%s\" but \"%s\"; prefer %s.%s for clarity", R_STRING_CLASSNAME, misleading, ASSUMED_MEANINGS.get(misleading), ASSUMED_MEANINGS.get(preferred), R_STRING_CLASSNAME, preferred)).addFix(SuggestedFix.replace(tree, state.getSourceForNode(tree.getExpression()) + "." + preferred)).build();
    }
}

