/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Optional;

public final class AutoValueRules {
    private AutoValueRules() {
    }

    public static ResultUseRule autoValues() {
        return new ValueRule();
    }

    public static ResultUseRule autoValueBuilders() {
        return new BuilderRule("AutoValue.Builder");
    }

    public static ResultUseRule autoBuilders() {
        return new BuilderRule("AutoBuilder");
    }

    private static abstract class AbstractAutoRule
    extends ResultUseRule.MethodRule {
        private static final String PACKAGE = "com.google.auto.value.";
        private final String annotation;

        AbstractAutoRule(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public String id() {
            return "@" + this.annotation;
        }

        protected abstract ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol var1, Symbol.ClassSymbol var2, VisitorState var3);

        private static boolean isAbstract(Symbol.MethodSymbol method) {
            return (method.flags() & 0x400L) != 0L;
        }

        @Override
        public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
            Symbol.ClassSymbol enclosingClass;
            if (AbstractAutoRule.isAbstract(method) && ASTHelpers.hasAnnotation((Symbol)(enclosingClass = ASTHelpers.enclosingClass(method)), PACKAGE + this.annotation, state)) {
                return Optional.of(this.autoMethodPolicy(method, enclosingClass, state));
            }
            return Optional.empty();
        }
    }

    private static final class BuilderRule
    extends AbstractAutoRule {
        BuilderRule(String annotation) {
            super(annotation);
        }

        @Override
        protected ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol abstractMethod, Symbol.ClassSymbol autoClass, VisitorState state) {
            return ((List)abstractMethod.getParameters()).size() == 1 && ASTHelpers.isSameType(abstractMethod.getReturnType(), autoClass.type, state) ? ResultUsePolicy.OPTIONAL : ResultUsePolicy.EXPECTED;
        }
    }

    private static final class ValueRule
    extends AbstractAutoRule {
        ValueRule() {
            super("AutoValue");
        }

        @Override
        protected ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol abstractMethod, Symbol.ClassSymbol autoClass, VisitorState state) {
            return ResultUsePolicy.EXPECTED;
        }
    }
}

