/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.MoreObjects;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Builder instance method does not return 'this'", severity=BugPattern.SeverityLevel.WARNING)
public class BuilderReturnThis
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String CRV = "com.google.errorprone.annotations.CheckReturnValue";

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        if (!BuilderReturnThis.instanceReturnsBuilder(sym, state)) {
            return Description.NO_MATCH;
        }
        if (!this.nonThisReturns(tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String crvName = SuggestedFixes.qualifyType(state, fix, CRV);
        fix.prefixWith(tree, "@" + crvName + "\n");
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private static boolean instanceReturnsBuilder(Symbol.MethodSymbol sym, VisitorState state) {
        if (sym.isStatic()) {
            return false;
        }
        Symbol.ClassSymbol enclosingClass = sym.owner.enclClass();
        if (!enclosingClass.getSimpleName().toString().endsWith("Builder")) {
            return false;
        }
        Type returnType = sym.getReturnType();
        return ASTHelpers.isSubtype((Type)enclosingClass.asType(), returnType, state) && !ASTHelpers.isSameType(returnType, state.getSymtab().objectType, state);
    }

    boolean nonThisReturns(MethodTree tree, final VisitorState state) {
        final boolean[] result = new boolean[]{false};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitReturn(ReturnTree tree, Void unused) {
                if (!this.returnsThis(tree.getExpression())) {
                    result[0] = true;
                }
                return (Void)super.visitReturn(tree, null);
            }

            private boolean returnsThis(ExpressionTree tree) {
                return MoreObjects.firstNonNull((Boolean)new TreeScanner<Boolean, Void>(){

                    @Override
                    public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                        return tree.getName().contentEquals("this");
                    }

                    @Override
                    public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                        return BuilderReturnThis.instanceReturnsBuilder(ASTHelpers.getSymbol(tree), state);
                    }

                    @Override
                    public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                        return Boolean.TRUE.equals(tree.getFalseExpression().accept(this, null)) && Boolean.TRUE.equals(tree.getTrueExpression().accept(this, null));
                    }

                    @Override
                    public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                        return tree.getExpression().accept(this, null);
                    }

                    @Override
                    public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                        return tree.getExpression().accept(this, null);
                    }
                }.scan(tree, null), false);
            }
        }.scan(tree.getBody(), null);
        return result[0];
    }
}

