/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Methods that always 'return this' should be annotated with @CanIgnoreReturnValue", severity=BugPattern.SeverityLevel.WARNING)
public final class CanIgnoreReturnValueSuggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String CRV = "com.google.errorprone.annotations.CheckReturnValue";
    private static final String CIRV = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final Supplier<Type> PROTO_BUILDER = VisitorState.memoize(s -> s.getTypeFromString("com.google.protobuf.MessageLite.Builder"));

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(methodTree);
        if (methodSymbol.isStatic() || methodTree.getBody() == null || CanIgnoreReturnValueSuggester.isDefinitionOfZeroArgSelf(methodSymbol) || methodTree.getReturnType() == null || ASTHelpers.isVoidType(ASTHelpers.getType(methodTree.getReturnType()), state) || CanIgnoreReturnValueSuggester.isSimpleReturnThisMethod(methodTree) || ASTHelpers.isSubtype(methodSymbol.owner.type, PROTO_BUILDER.get(state), state) || ASTHelpers.hasAnnotation((Symbol)methodSymbol, CIRV, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)methodTree, CRV, state)) {
            return Description.NO_MATCH;
        }
        if (!CanIgnoreReturnValueSuggester.methodReturnsIgnorableValues(methodTree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String cirvName = SuggestedFixes.qualifyType(state, fix, CIRV);
        fix.prefixWith(methodTree, "@" + cirvName + "\n");
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static boolean isSimpleReturnThisMethod(MethodTree methodTree) {
        StatementTree onlyStatement;
        if (methodTree.getBody().getStatements().size() == 1 && (onlyStatement = methodTree.getBody().getStatements().get(0)) instanceof ReturnTree) {
            return CanIgnoreReturnValueSuggester.returnsThisOrSelf((ReturnTree)onlyStatement);
        }
        return false;
    }

    private static boolean isIdentifier(ExpressionTree expr, String identifierName) {
        if ((expr = ASTHelpers.stripParentheses(expr)) instanceof IdentifierTree) {
            return ((IdentifierTree)expr).getName().contentEquals(identifierName);
        }
        return false;
    }

    private static boolean returnsThisOrSelf(ReturnTree returnTree) {
        return CanIgnoreReturnValueSuggester.isIdentifier(returnTree.getExpression(), "this") || returnTree.getExpression() instanceof MethodInvocationTree && CanIgnoreReturnValueSuggester.isCallToZeroArgSelf((MethodInvocationTree)returnTree.getExpression());
    }

    private static boolean isCallToZeroArgSelf(MethodInvocationTree mit) {
        if (!mit.getArguments().isEmpty()) {
            return false;
        }
        if (CanIgnoreReturnValueSuggester.isIdentifier(mit.getMethodSelect(), "self")) {
            return true;
        }
        if (mit.getMethodSelect() instanceof MemberSelectTree) {
            MemberSelectTree methodSelect = (MemberSelectTree)mit.getMethodSelect();
            return CanIgnoreReturnValueSuggester.isIdentifier(methodSelect.getExpression(), "this") && methodSelect.getIdentifier().contentEquals("self");
        }
        return false;
    }

    private static boolean isDefinitionOfZeroArgSelf(Symbol.MethodSymbol methodSymbol) {
        return ((Name)methodSymbol.getSimpleName()).contentEquals("self") && ((List)methodSymbol.getParameters()).isEmpty();
    }

    private static boolean methodReturnsIgnorableValues(MethodTree tree, VisitorState state) {
        class ReturnValuesFromMethodAreIgnorable
        extends TreeScanner<Void, Void> {
            private final VisitorState state;
            private final Type enclosingClassType;
            private final Type methodReturnType;
            private boolean atLeastOneReturn = false;
            private boolean allReturnsIgnorable = true;

            private ReturnValuesFromMethodAreIgnorable(VisitorState state, Symbol.MethodSymbol methSymbol) {
                this.state = state;
                this.methodReturnType = methSymbol.getReturnType();
                this.enclosingClassType = methSymbol.enclClass().type;
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                this.atLeastOneReturn = true;
                if (!CanIgnoreReturnValueSuggester.returnsThisOrSelf(returnTree) && !this.isIgnorableMethodCallOnSameInstance(returnTree, this.state)) {
                    this.allReturnsIgnorable = false;
                }
                return null;
            }

            private boolean isIgnorableMethodCallOnSameInstance(ReturnTree returnTree, VisitorState state) {
                if (returnTree.getExpression() instanceof MethodInvocationTree) {
                    MethodInvocationTree mit = (MethodInvocationTree)returnTree.getExpression();
                    ExpressionTree receiver = ASTHelpers.getReceiver(mit);
                    Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol(mit);
                    if (receiver == null && !calledMethod.isStatic() || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "this") || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "super")) {
                        return ASTHelpers.hasAnnotation((Symbol)calledMethod, CanIgnoreReturnValueSuggester.CIRV, state) && ASTHelpers.isSubtype(this.enclosingClassType, this.methodReturnType, state) && ASTHelpers.isSubtype(this.enclosingClassType, ASTHelpers.getReturnType(mit), state);
                    }
                }
                return false;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }
        ReturnValuesFromMethodAreIgnorable scanner = new ReturnValuesFromMethodAreIgnorable(state, ASTHelpers.getSymbol(tree));
        scanner.scan(tree, null);
        return scanner.atLeastOneReturn && scanner.allReturnsIgnorable;
    }
}

