/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(summary="@CanIgnoreReturnValue should not be applied to classes as it almost always overmatches (as it applies to constructors and all methods), and the CIRVness isn't conferred to its subclasses.", severity=BugPattern.SeverityLevel.ERROR)
public final class NoCanIgnoreReturnValueOnClasses
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String CRV = "com.google.errorprone.annotations.CheckReturnValue";
    private static final String CIRV = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final String EXTRA_SUFFIX = "";
    @VisibleForTesting
    static final String METHOD_COMMENT = " // pushed down from class to method;";
    @VisibleForTesting
    static final String CTOR_COMMENT = " // pushed down from class to constructor;";
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_CIRV_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isType("com.google.errorprone.annotations.CanIgnoreReturnValue"));

    @Override
    public Description matchClass(ClassTree tree, final VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> cirvAnnotation = HAS_CIRV_ANNOTATION.multiMatchResult(tree, state);
        if (!cirvAnnotation.matches()) {
            return Description.NO_MATCH;
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final String cirvName = SuggestedFixes.qualifyType(state, fix, CIRV);
        fix.delete(cirvAnnotation.onlyMatchingNode());
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                return ASTHelpers.hasAnnotation((Tree)classTree, NoCanIgnoreReturnValueOnClasses.CRV, state) ? null : (Void)super.visitClass(classTree, unused);
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Void unused) {
                if (this.shouldAddCirv(methodTree, state)) {
                    String trailingComment = null;
                    trailingComment = methodTree.getReturnType() == null ? NoCanIgnoreReturnValueOnClasses.CTOR_COMMENT : (this.alwaysReturnsThis() ? NoCanIgnoreReturnValueOnClasses.EXTRA_SUFFIX : NoCanIgnoreReturnValueOnClasses.METHOD_COMMENT);
                    fix.prefixWith(methodTree, "@" + cirvName + trailingComment + "\n");
                }
                return null;
            }

            private boolean alwaysReturnsThis() {
                final AtomicBoolean allReturnThis = new AtomicBoolean(true);
                final AtomicBoolean atLeastOneReturn = new AtomicBoolean(false);
                new TreePathScanner<Void, Void>(){
                    private final Set<Symbol.VarSymbol> thises = new HashSet<Symbol.VarSymbol>();

                    @Override
                    public Void visitVariable(VariableTree variableTree, Void unused) {
                        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(variableTree);
                        if (ASTHelpers.isConsideredFinal(symbol) && this.maybeCastThis(variableTree.getInitializer())) {
                            this.thises.add(symbol);
                        }
                        return (Void)super.visitVariable(variableTree, null);
                    }

                    @Override
                    public Void visitReturn(ReturnTree returnTree, Void unused) {
                        atLeastOneReturn.set(true);
                        if (!this.isThis(returnTree.getExpression())) {
                            allReturnThis.set(false);
                            return null;
                        }
                        return (Void)super.visitReturn(returnTree, null);
                    }

                    private boolean isThis(ExpressionTree returnExpression) {
                        return this.maybeCastThis(returnExpression) || this.thises.contains(ASTHelpers.getSymbol(returnExpression));
                    }

                    @Override
                    public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                        return null;
                    }

                    @Override
                    public Void visitNewClass(NewClassTree node, Void unused) {
                        return null;
                    }

                    private boolean maybeCastThis(Tree tree) {
                        return MoreObjects.firstNonNull((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

                            @Override
                            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                                return (Boolean)this.visit(tree.getExpression(), null);
                            }

                            @Override
                            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                                return tree.getName().contentEquals("this");
                            }

                            @Override
                            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                                return ((Name)ASTHelpers.getSymbol(tree).getSimpleName()).contentEquals("self");
                            }
                        }.visit(tree, null), false);
                    }
                }.scan(this.getCurrentPath(), (Void)null);
                return allReturnThis.get() && atLeastOneReturn.get();
            }

            private boolean shouldAddCirv(MethodTree methodTree, VisitorState state2) {
                if (ASTHelpers.isVoidType(ASTHelpers.getType(methodTree.getReturnType()), state2)) {
                    return false;
                }
                if (ASTHelpers.hasAnnotation((Tree)methodTree, NoCanIgnoreReturnValueOnClasses.CIRV, state2)) {
                    return false;
                }
                if (ASTHelpers.hasAnnotation((Tree)methodTree, NoCanIgnoreReturnValueOnClasses.CRV, state2)) {
                    return false;
                }
                if (ASTHelpers.isGeneratedConstructor(methodTree)) {
                    return false;
                }
                Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass(ASTHelpers.getSymbol(methodTree));
                return !ASTHelpers.hasAnnotation((Symbol)enclosingClass, "com.google.auto.value.AutoValue", state2) && !ASTHelpers.hasAnnotation((Symbol)enclosingClass, "com.google.auto.value.AutoValue.Builder", state2) || methodTree.getBody() != null;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }.scan(state.getPath(), (Void)null);
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

