/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.suppliers.Supplier;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Optional;

public final class PackagesRule
extends ResultUseRule.SymbolRule {
    private final Supplier<ImmutableMap<Name, Boolean>> packagesSupplier = VisitorState.memoize(state -> {
        ImmutableMap.Builder<Name, Boolean> builder = ImmutableMap.builder();
        for (String pattern : patterns) {
            if (pattern.charAt(0) == '-') {
                builder.put(state.getName(pattern.substring(1)), false);
                continue;
            }
            builder.put(state.getName(pattern), true);
        }
        return builder.buildOrThrow();
    });

    public static PackagesRule fromPatterns(Iterable<String> patterns) {
        return new PackagesRule(ImmutableList.copyOf(patterns));
    }

    private PackagesRule(ImmutableList<String> patterns) {
    }

    @Override
    public final String id() {
        return "Packages";
    }

    @Override
    public Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState state) {
        while (symbol instanceof Symbol.PackageSymbol) {
            Boolean value = this.packagesSupplier.get(state).get(((Symbol.PackageSymbol)symbol).fullname);
            if (value != null) {
                return value != false ? Optional.of(ResultUsePolicy.EXPECTED) : Optional.empty();
            }
            symbol = symbol.owner;
        }
        return Optional.empty();
    }
}

