/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import java.util.regex.Pattern;

public final class ProtoRules {
    private ProtoRules() {
    }

    public static ResultUseRule protoBuilders() {
        return new ProtoRule(ProtoRules.supplier("com.google.protobuf.MessageLite.Builder"), "PROTO_BUILDER");
    }

    public static ResultUseRule mutableProtos() {
        return new ProtoRule(ProtoRules.supplier("com.google.protobuf.AbstractMutableMessageLite"), "MUTABLE_PROTO");
    }

    private static Supplier<Type> supplier(String name) {
        return VisitorState.memoize(s -> s.getTypeFromString(name));
    }

    private static final class ProtoRule
    extends ResultUseRule.MethodRule {
        private static final Pattern NAMED_MUTATOR_METHOD = Pattern.compile("(add|clear|insert|merge|remove|set|put).*");
        private final Supplier<Type> parentType;
        private final String id;

        ProtoRule(Supplier<Type> parentType, String id) {
            this.parentType = Preconditions.checkNotNull(parentType);
            this.id = Preconditions.checkNotNull(id);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
            if (this.isProtoSubtype(method.owner.type, state)) {
                String methodName = method.name.toString();
                if (NAMED_MUTATOR_METHOD.matcher(methodName).matches()) {
                    return Optional.of(ResultUsePolicy.OPTIONAL);
                }
                if (ProtoRule.isMutatingAccessorMethod(methodName) && this.isProtoSubtype(method.getReturnType(), state)) {
                    return Optional.of(ResultUsePolicy.OPTIONAL);
                }
            }
            return Optional.empty();
        }

        private boolean isProtoSubtype(Type ownerType, VisitorState state) {
            return ASTHelpers.isSubtype(ownerType, this.parentType.get(state), state);
        }

        private static boolean isMutatingAccessorMethod(String name) {
            if (name.startsWith("get")) {
                return name.endsWith("Builder") && !name.endsWith("OrBuilder") || name.startsWith("getMutable");
            }
            return false;
        }
    }
}

