/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

public final class ResultUsePolicyEvaluator {
    private static final ImmutableListMultimap<ElementKind, ResultUseRule.RuleScope> SCOPES = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().putAll((Object)ElementKind.METHOD, (Object[])new ResultUseRule.RuleScope[]{ResultUseRule.RuleScope.METHOD, ResultUseRule.RuleScope.ENCLOSING_ELEMENTS, ResultUseRule.RuleScope.GLOBAL})).putAll((Object)ElementKind.CONSTRUCTOR, (Object[])new ResultUseRule.RuleScope[]{ResultUseRule.RuleScope.METHOD, ResultUseRule.RuleScope.ENCLOSING_ELEMENTS, ResultUseRule.RuleScope.GLOBAL})).build();
    private final ImmutableListMultimap<ResultUseRule.RuleScope, ResultUseRule> rules;

    public static ResultUsePolicyEvaluator create(ResultUseRule ... rules) {
        return ResultUsePolicyEvaluator.create(Arrays.asList(rules));
    }

    public static ResultUsePolicyEvaluator create(Iterable<? extends ResultUseRule> rules) {
        return ResultUsePolicyEvaluator.builder().addRules(rules).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResultUsePolicyEvaluator(Builder builder) {
        this.rules = builder.rules.stream().flatMap(rule -> rule.scopes().stream().map(scope -> Map.entry(scope, rule))).collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ResultUsePolicy evaluate(Symbol.MethodSymbol method, VisitorState state) {
        return this.policies(method, state).findFirst().orElse(ResultUsePolicy.OPTIONAL);
    }

    private Stream<ResultUsePolicy> policies(Symbol.MethodSymbol method, VisitorState state) {
        return SCOPES.get((Object)method.getKind()).stream().flatMap(scope -> scope.policies(method, state, this.rules));
    }

    public Stream<ResultUseRule.Evaluation> evaluations(Symbol.MethodSymbol method, VisitorState state) {
        return SCOPES.get((Object)method.getKind()).stream().flatMap(scope -> scope.evaluations(method, state, this.rules));
    }

    public static final class Builder {
        private final List<ResultUseRule> rules = new ArrayList<ResultUseRule>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder addRule(ResultUseRule rule) {
            this.rules.add(rule);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addRules(ResultUseRule ... rules) {
            return this.addRules(Arrays.asList(rules));
        }

        @CanIgnoreReturnValue
        public Builder addRules(Iterable<? extends ResultUseRule> rules) {
            rules.forEach(this::addRule);
            return this;
        }

        public ResultUsePolicyEvaluator build() {
            return new ResultUsePolicyEvaluator(this);
        }
    }
}

