/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.AutoValue_ResultUseRule_Evaluation;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class ResultUseRule {
    private ResultUseRule() {
    }

    public abstract String id();

    public abstract ImmutableSet<RuleScope> scopes();

    public abstract Optional<ResultUsePolicy> evaluate(Symbol var1, VisitorState var2);

    public final Optional<Evaluation> evaluate(RuleScope scope, Symbol symbol, VisitorState state) {
        return this.evaluate(symbol, state).map(policy -> Evaluation.create(this, scope, symbol, policy));
    }

    public final String toString() {
        return this.id();
    }

    @AutoValue
    public static abstract class Evaluation {
        public static Evaluation create(ResultUseRule rule, RuleScope scope, Symbol element, ResultUsePolicy policy) {
            return new AutoValue_ResultUseRule_Evaluation(rule, scope, element, policy);
        }

        public abstract ResultUseRule rule();

        public abstract RuleScope scope();

        public abstract Symbol element();

        public abstract ResultUsePolicy policy();
    }

    public static enum RuleScope {
        METHOD{

            @Override
            Stream<Symbol> members(Symbol.MethodSymbol method) {
                return Stream.of(method);
            }
        }
        ,
        ENCLOSING_ELEMENTS{

            @Override
            Stream<Symbol> members(Symbol.MethodSymbol method) {
                return ASTHelpers.enclosingElements(method).filter(s -> s instanceof Symbol.ClassSymbol || s instanceof Symbol.PackageSymbol);
            }
        }
        ,
        GLOBAL{

            @Override
            Stream<Symbol> members(Symbol.MethodSymbol method) {
                return Stream.of(method);
            }
        };


        abstract Stream<Symbol> members(Symbol.MethodSymbol var1);

        final Stream<ResultUsePolicy> policies(Symbol.MethodSymbol method, VisitorState state, ListMultimap<RuleScope, ResultUseRule> rules) {
            Collection scopeRules = rules.get((Object)this);
            return this.members(method).flatMap(arg_0 -> RuleScope.lambda$policies$1((List)scopeRules, state, arg_0)).flatMap(Optional::stream);
        }

        final Stream<Evaluation> evaluations(Symbol.MethodSymbol method, VisitorState state, ListMultimap<RuleScope, ResultUseRule> rules) {
            Collection scopeRules = rules.get((Object)this);
            return this.members(method).flatMap(arg_0 -> this.lambda$evaluations$3((List)scopeRules, state, arg_0)).flatMap(Optional::stream);
        }

        private /* synthetic */ Stream lambda$evaluations$3(List scopeRules, VisitorState state, Symbol symbol) {
            return scopeRules.stream().map(rule -> rule.evaluate(this, symbol, state));
        }

        private static /* synthetic */ Stream lambda$policies$1(List scopeRules, VisitorState state, Symbol symbol) {
            return scopeRules.stream().map(rule -> rule.evaluate(symbol, state));
        }
    }

    public static abstract class GlobalRule
    extends ResultUseRule {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.GLOBAL);

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }

        public abstract Optional<ResultUsePolicy> evaluate(boolean var1, VisitorState var2);

        @Override
        public final Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState state) {
            return this.evaluate(symbol.isConstructor(), state);
        }
    }

    public static abstract class SymbolRule
    extends ResultUseRule {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.METHOD, RuleScope.ENCLOSING_ELEMENTS);

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }
    }

    public static abstract class MethodRule
    extends ResultUseRule {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.METHOD);

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }

        public abstract Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol var1, VisitorState var2);

        @Override
        public final Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState state) {
            return symbol instanceof Symbol.MethodSymbol ? this.evaluateMethod((Symbol.MethodSymbol)symbol, state) : Optional.empty();
        }
    }
}

