/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.Preconditions;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import java.util.function.BiPredicate;

public final class Rules {
    private Rules() {
    }

    public static ResultUseRule globalDefault(Optional<ResultUsePolicy> methodDefault, Optional<ResultUsePolicy> constructorDefault) {
        return new SimpleGlobalRule("GLOBAL_DEFAULT", methodDefault, constructorDefault);
    }

    public static ResultUseRule mapAnnotationSimpleName(String simpleName, ResultUsePolicy policy) {
        return new SimpleRule("ANNOTATION @" + simpleName, (sym, st) -> ASTHelpers.hasDirectAnnotationWithSimpleName(sym, simpleName), policy);
    }

    private static final class SimpleGlobalRule
    extends ResultUseRule.GlobalRule {
        private final String id;
        private final Optional<ResultUsePolicy> methodDefault;
        private final Optional<ResultUsePolicy> constructorDefault;

        private SimpleGlobalRule(String id, Optional<ResultUsePolicy> methodDefault, Optional<ResultUsePolicy> constructorDefault) {
            this.id = Preconditions.checkNotNull(id);
            this.methodDefault = methodDefault;
            this.constructorDefault = constructorDefault;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<ResultUsePolicy> evaluate(boolean constructor, VisitorState state) {
            return constructor ? this.constructorDefault : this.methodDefault;
        }
    }

    private static final class SimpleRule
    extends ResultUseRule.SymbolRule {
        private final String name;
        private final BiPredicate<Symbol, VisitorState> predicate;
        private final ResultUsePolicy policy;

        private SimpleRule(String name, BiPredicate<Symbol, VisitorState> predicate, ResultUsePolicy policy) {
            this.name = name;
            this.predicate = predicate;
            this.policy = policy;
        }

        @Override
        public String id() {
            return this.name;
        }

        @Override
        public Optional<ResultUsePolicy> evaluate(Symbol symbol, VisitorState state) {
            return this.predicate.test(symbol, state) ? Optional.of(this.policy) : Optional.empty();
        }
    }
}

