/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.auto.value.AutoValue;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AutoValue_AbstractCollectionIncompatibleTypeMatcher_MatchResult;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractCollectionIncompatibleTypeMatcher {
    abstract Matcher<ExpressionTree> methodMatcher();

    @Nullable
    abstract Type extractSourceType(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    abstract Type extractSourceType(MemberReferenceTree var1, VisitorState var2);

    @Nullable
    abstract ExpressionTree extractSourceTree(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    abstract ExpressionTree extractSourceTree(MemberReferenceTree var1, VisitorState var2);

    @Nullable
    abstract Type extractTargetType(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    abstract Type extractTargetType(MemberReferenceTree var1, VisitorState var2);

    @Nullable
    public final MatchResult matches(ExpressionTree tree, final VisitorState state) {
        if (!this.methodMatcher().matches(tree, state)) {
            return null;
        }
        return (MatchResult)new SimpleTreeVisitor<MatchResult, Void>(){

            @Override
            public MatchResult visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void unused) {
                return AbstractCollectionIncompatibleTypeMatcher.this.getMatchResult(AbstractCollectionIncompatibleTypeMatcher.this.extractSourceTree(methodInvocationTree, state), AbstractCollectionIncompatibleTypeMatcher.this.extractSourceType(methodInvocationTree, state), AbstractCollectionIncompatibleTypeMatcher.this.extractTargetType(methodInvocationTree, state));
            }

            @Override
            public MatchResult visitMemberReference(MemberReferenceTree memberReferenceTree, Void unused) {
                return AbstractCollectionIncompatibleTypeMatcher.this.getMatchResult(AbstractCollectionIncompatibleTypeMatcher.this.extractSourceTree(memberReferenceTree, state), AbstractCollectionIncompatibleTypeMatcher.this.extractSourceType(memberReferenceTree, state), AbstractCollectionIncompatibleTypeMatcher.this.extractTargetType(memberReferenceTree, state));
            }
        }.visit(tree, null);
    }

    @Nullable
    private MatchResult getMatchResult(@Nullable ExpressionTree sourceTree, @Nullable Type sourceType, @Nullable Type targetType) {
        if (sourceTree == null || sourceType == null || targetType == null) {
            return null;
        }
        return MatchResult.create(sourceTree, sourceType, targetType, this);
    }

    @Nullable
    protected static Type extractTypeArgAsMemberOfSupertype(Type type, Symbol superTypeSym, int typeArgIndex, Types types) {
        Type collectionType = types.asSuper(type, superTypeSym);
        if (collectionType == null) {
            return null;
        }
        List<Type> tyargs = collectionType.getTypeArguments();
        if (tyargs.size() <= typeArgIndex) {
            return null;
        }
        return tyargs.get(typeArgIndex);
    }

    Optional<Fix> buildFix(MatchResult result) {
        return Optional.empty();
    }

    protected String message(MatchResult result, String sourceType, String targetType) {
        return String.format("Argument '%s' should not be passed to this method; its type %s is not compatible with %s", result.sourceTree(), sourceType, targetType);
    }

    @AutoValue
    public static abstract class MatchResult {
        public abstract ExpressionTree sourceTree();

        public abstract Type sourceType();

        public abstract Type targetType();

        public abstract AbstractCollectionIncompatibleTypeMatcher matcher();

        public static MatchResult create(ExpressionTree sourceTree, Type sourceType, Type targetType, AbstractCollectionIncompatibleTypeMatcher matcher) {
            return new AutoValue_AbstractCollectionIncompatibleTypeMatcher_MatchResult(sourceTree, sourceType, targetType, matcher);
        }

        public String message(String sourceType, String targetType) {
            return this.matcher().message(this, sourceType, targetType);
        }

        public Optional<Fix> buildFix() {
            return this.matcher().buildFix(this);
        }
    }
}

