/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.ContainmentMatchers;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Types;

@BugPattern(summary="Incompatible type as argument to Object-accepting Java collections method", severity=BugPattern.SeverityLevel.ERROR)
public class CollectionIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private final FixType fixType;
    private final TypeCompatibilityUtils typeCompatibilityUtils;

    public CollectionIncompatibleType(ErrorProneFlags flags) {
        this.fixType = flags.getEnum("CollectionIncompatibleType:FixType", FixType.class).orElse(FixType.NONE);
        this.typeCompatibilityUtils = TypeCompatibilityUtils.fromFlags(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.match(tree, state);
    }

    public Description match(ExpressionTree tree, VisitorState state) {
        String targetType;
        AbstractCollectionIncompatibleTypeMatcher.MatchResult result = ContainmentMatchers.firstNonNullMatchResult(tree, state);
        if (result == null) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        TypeCompatibilityUtils.TypeCompatibilityReport compatibilityReport = this.typeCompatibilityUtils.compatibilityOfTypes(result.targetType(), result.sourceType(), state);
        if (compatibilityReport.isCompatible()) {
            return Description.NO_MATCH;
        }
        String sourceType = Signatures.prettyType(result.sourceType());
        if (sourceType.equals(targetType = Signatures.prettyType(result.targetType()))) {
            sourceType = result.sourceType().toString();
            targetType = result.targetType().toString();
        }
        Description.Builder description = this.buildDescription(tree).setMessage(result.message(sourceType, targetType) + compatibilityReport.extraReason());
        switch (this.fixType) {
            case PRINT_TYPES_AS_COMMENT: {
                description.addFix(SuggestedFix.prefixWith(tree, String.format("/* expected: %s, actual: %s */", ASTHelpers.getUpperBound(result.targetType(), types), result.sourceType())));
                break;
            }
            case CAST: {
                result.buildFix().ifPresent(description::addFix);
                break;
            }
            case SUPPRESS_WARNINGS: {
                SuggestedFix.Builder builder = SuggestedFix.builder();
                builder.prefixWith(result.sourceTree(), String.format("/* expected: %s, actual: %s */ ", targetType, sourceType));
                SuggestedFixes.addSuppressWarnings(builder, state, "CollectionIncompatibleType");
                description.addFix(builder.build());
                break;
            }
        }
        return description.build();
    }

    private static enum FixType {
        NONE,
        CAST,
        PRINT_TYPES_AS_COMMENT,
        SUPPRESS_WARNINGS;

    }
}

