/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.stream.Stream;

@BugPattern(summary="Argument is not compatible with the subject's type.", severity=BugPattern.SeverityLevel.WARNING)
public class TruthIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> START_OF_ASSERTION = Matchers.anyOf(MethodMatchers.staticMethod().onClassAny("com.google.common.truth.Truth", "com.google.common.truth.Truth8").named("assertThat"), MethodMatchers.staticMethod().onClass("com.google.common.truth.extensions.proto.ProtoTruth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that"));
    private static final Matcher<ExpressionTree> IS_EQUAL_TO = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf("isEqualTo", "isNotEqualTo"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoFluentAssertion").namedAnyOf("isEqualTo", "isNotEqualTo"));
    private static final Matcher<ExpressionTree> FLUENT_PROTO_CHAIN = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoFluentAssertion"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.extensions.proto.ProtoSubject"));
    private static final Matcher<ExpressionTree> SCALAR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny("com.google.common.truth.IterableSubject", "com.google.common.truth.StreamSubject").namedAnyOf("contains", "containsExactly", "doesNotContain", "containsAnyOf", "containsNoneOf");
    private static final Matcher<ExpressionTree> VECTOR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny("com.google.common.truth.IterableSubject", "com.google.common.truth.StreamSubject").namedAnyOf("containsExactlyElementsIn", "containsAnyIn", "containsAtLeastElementsIn", "containsNoneIn").withParameters("java.lang.Iterable", new String[0]);
    private static final Matcher<ExpressionTree> MAP_SCALAR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny("com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject").namedAnyOf("containsEntry", "doesNotContainEntry", "containsExactly", "containsAtLeast");
    private static final Matcher<ExpressionTree> MAP_SCALAR_KEYS = MethodMatchers.instanceMethod().onDescendantOfAny("com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject").namedAnyOf("containsKey", "doesNotContainKey");
    private static final Matcher<ExpressionTree> MAP_VECTOR_CONTAINS = MethodMatchers.instanceMethod().onDescendantOfAny("com.google.common.truth.MapSubject", "com.google.common.truth.MultimapSubject").namedAnyOf("containsExactlyEntriesIn", "containsAtLeastEntriesIn");
    private static final Matcher<ExpressionTree> COMPARING_ELEMENTS_USING = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.IterableSubject").named("comparingElementsUsing");
    private static final Matcher<ExpressionTree> ARRAY_CONTAINS = Matchers.allOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.IterableSubject").namedAnyOf("containsExactlyElementsIn", "containsAnyIn", "containsAtLeastElementsIn", "containsNoneIn"), Matchers.not(VECTOR_CONTAINS));
    private static final Supplier<Type> CORRESPONDENCE = Suppliers.typeFromString("com.google.common.truth.Correspondence");
    private final TypeCompatibilityUtils typeCompatibilityUtils;
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize(state -> state.getTypeFromString("java.lang.Number"));

    public TruthIncompatibleType(ErrorProneFlags flags) {
        this.typeCompatibilityUtils = TypeCompatibilityUtils.fromFlags(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Streams.concat(this.matchEquality(tree, state), this.matchVectorContains(tree, state), this.matchArrayContains(tree, state), this.matchScalarContains(tree, state), this.matchCorrespondence(tree, state), this.matchMapVectorContains(tree, state), this.matchMapScalarContains(tree, state), this.matchMapContainsKey(tree, state)).forEach(state::reportMatch);
        return Description.NO_MATCH;
    }

    private Stream<Description> matchEquality(MethodInvocationTree tree, VisitorState state) {
        if (!IS_EQUAL_TO.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        while (true) {
            if (!(receiver instanceof MethodInvocationTree)) {
                return Stream.empty();
            }
            if (START_OF_ASSERTION.matches(receiver, state)) break;
            if (!FLUENT_PROTO_CHAIN.matches(receiver, state)) {
                return Stream.empty();
            }
            receiver = ASTHelpers.getReceiver(receiver);
        }
        Type targetType = ASTHelpers.getType(this.ignoringCasts(Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())));
        Type sourceType = ASTHelpers.getType(Iterables.getOnlyElement(tree.getArguments()));
        if (TruthIncompatibleType.isNumericType(sourceType, state) && TruthIncompatibleType.isNumericType(targetType, state)) {
            return Stream.of(new Description[0]);
        }
        return this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchVectorContains(MethodInvocationTree tree, VisitorState state) {
        if (!VECTOR_CONTAINS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts(Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        Type sourceType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, Iterables.getOnlyElement(tree.getArguments()), state);
        return this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchArrayContains(MethodInvocationTree tree, VisitorState state) {
        if (!ARRAY_CONTAINS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts(Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        Type sourceType = ((Type.ArrayType)ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())))).elemtype;
        return this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetType, sourceType, state);
    }

    private Stream<Description> matchScalarContains(MethodInvocationTree tree, VisitorState state) {
        if (!SCALAR_CONTAINS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        Tree argument = this.ignoringCasts(Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments()));
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, argument, state);
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
        return Streams.mapWithIndex(tree.getArguments().stream(), (arg, index) -> {
            Type argumentType = ASTHelpers.getType(arg);
            return TruthIncompatibleType.isNonVarargsCall(methodSymbol, index, argumentType) ? this.checkCompatibility((ExpressionTree)arg, targetType, ((Type.ArrayType)argumentType).elemtype, state) : this.checkCompatibility((ExpressionTree)arg, targetType, argumentType, state);
        }).flatMap(x -> x);
    }

    private Stream<Description> matchCorrespondence(MethodInvocationTree tree, VisitorState state) {
        String targetTypeName;
        if (!COMPARING_ELEMENTS_USING.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        Type targetType = TruthIncompatibleType.getIterableTypeArg(((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type, this.ignoringCasts(Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments())), state);
        if (targetType == null) {
            return Stream.empty();
        }
        ExpressionTree argument = Iterables.getOnlyElement(tree.getArguments());
        Type sourceType = TruthIncompatibleType.getCorrespondenceTypeArg(argument, state);
        if (sourceType == null || ASTHelpers.isCastable(targetType, sourceType, state)) {
            return Stream.empty();
        }
        String sourceTypeName = Signatures.prettyType(sourceType);
        if (sourceTypeName.equals(targetTypeName = Signatures.prettyType(targetType))) {
            sourceTypeName = sourceType.toString();
            targetTypeName = targetType.toString();
        }
        return Stream.of(this.buildDescription(argument).setMessage(String.format("Argument '%s' should not be passed to this method: its type `%s` is not compatible with `%s`", state.getSourceForNode(argument), sourceTypeName, targetTypeName)).build());
    }

    private Stream<Description> matchMapVectorContains(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_VECTOR_CONTAINS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        Type targetValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(this.ignoringCasts(assertee)), assertionType, 1, state.getTypes());
        Type sourceKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(Iterables.getOnlyElement(tree.getArguments())), assertionType, 0, state.getTypes());
        Type sourceValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(Iterables.getOnlyElement(tree.getArguments())), assertionType, 1, state.getTypes());
        return Stream.concat(this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetKeyType, sourceKeyType, state), this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetValueType, sourceValueType, state));
    }

    private Stream<Description> matchMapContainsKey(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_SCALAR_KEYS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        return this.checkCompatibility(Iterables.getOnlyElement(tree.getArguments()), targetKeyType, ASTHelpers.getType(Iterables.getOnlyElement(tree.getArguments())), state);
    }

    private Stream<Description> matchMapScalarContains(MethodInvocationTree tree, VisitorState state) {
        if (!MAP_SCALAR_CONTAINS.matches(tree, state)) {
            return Stream.empty();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (!START_OF_ASSERTION.matches(receiver, state)) {
            return Stream.empty();
        }
        ExpressionTree assertee = Iterables.getOnlyElement(((MethodInvocationTree)receiver).getArguments());
        Symbol.TypeSymbol assertionType = ((Symbol.VarSymbol)Iterables.getOnlyElement(ASTHelpers.getSymbol((MethodInvocationTree)((MethodInvocationTree)receiver)).getParameters())).type.tsym;
        Type targetKeyType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(this.ignoringCasts(assertee)), assertionType, 0, state.getTypes());
        Type targetValueType = AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(this.ignoringCasts(assertee)), assertionType, 1, state.getTypes());
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
        return Streams.mapWithIndex(tree.getArguments().stream(), (arg, index) -> TruthIncompatibleType.isNonVarargsCall(methodSymbol, index, ASTHelpers.getType(arg)) ? Stream.empty() : this.checkCompatibility((ExpressionTree)arg, index % 2L == 0L ? targetKeyType : targetValueType, ASTHelpers.getType(arg), state)).flatMap(x -> x);
    }

    private static boolean isNonVarargsCall(Symbol.MethodSymbol methodSymbol, long index, Type argumentType) {
        return (long)(((List)methodSymbol.getParameters()).size() - 1) == index && methodSymbol.isVarArgs() && argumentType instanceof Type.ArrayType && !((Type.ArrayType)argumentType).elemtype.isPrimitive();
    }

    private Stream<Description> checkCompatibility(ExpressionTree tree, Type targetType, Type sourceType, VisitorState state) {
        String targetTypeName;
        TypeCompatibilityUtils.TypeCompatibilityReport compatibilityReport = this.typeCompatibilityUtils.compatibilityOfTypes(targetType, sourceType, state);
        if (compatibilityReport.isCompatible()) {
            return Stream.empty();
        }
        String sourceTypeName = Signatures.prettyType(sourceType);
        if (sourceTypeName.equals(targetTypeName = Signatures.prettyType(targetType))) {
            sourceTypeName = sourceType.toString();
            targetTypeName = targetType.toString();
        }
        return Stream.of(this.buildDescription(tree).setMessage(String.format("Argument '%s' should not be passed to this method: its type `%s` is not compatible with `%s`" + compatibilityReport.extraReason(), state.getSourceForNode(tree), sourceTypeName, targetTypeName)).build());
    }

    private Tree ignoringCasts(Tree tree) {
        return tree.accept(new SimpleTreeVisitor<Tree, Void>(){

            @Override
            protected Tree defaultAction(Tree node, Void unused) {
                return node;
            }

            @Override
            public Tree visitTypeCast(TypeCastTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            public Tree visitParenthesized(ParenthesizedTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }
        }, null);
    }

    private static Type getIterableTypeArg(Type type, Tree onlyElement, VisitorState state) {
        return AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(onlyElement), type.tsym, 0, state.getTypes());
    }

    private static Type getCorrespondenceTypeArg(Tree onlyElement, VisitorState state) {
        return AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(onlyElement), TruthIncompatibleType.CORRESPONDENCE.get((VisitorState)state).tsym, 0, state.getTypes());
    }

    private static boolean isNumericType(Type parameter, VisitorState state) {
        return parameter.isNumeric() || ASTHelpers.isSubtype(parameter, JAVA_LANG_NUMBER.get(state), state);
    }
}

