/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;

@BugPattern(summary="logVarargs should be used to pass through format strings and arguments.", severity=BugPattern.SeverityLevel.ERROR)
public final class FloggerLogVarargs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log"), Matchers.argument(0, Matchers.isSameType(Suppliers.STRING_TYPE)), Matchers.argument(1, Matchers.isSameType(Suppliers.arrayOf(Suppliers.OBJECT_TYPE))));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        MethodTree enclosingMethod = (MethodTree)state.findEnclosing(MethodTree.class);
        if (enclosingMethod == null) {
            return Description.NO_MATCH;
        }
        return ASTHelpers.constValue(tree.getArguments().get(0)) == null ? this.describeMatch(tree, (Fix)SuggestedFixes.renameMethodInvocation(tree, "logVarargs", state)) : Description.NO_MATCH;
    }
}

